/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.eac;

import de.cardcontact.opencard.eac.cvc.CVCertificate;
import de.cardcontact.opencard.eac.cvc.CertificateHolderReference;
import de.cardcontact.opencard.eac.cvc.CertificationAuthorityReference;
import de.cardcontact.opencard.eac.cvc.ECPublicKeyTLV;
import de.cardcontact.tlv.ObjectIdentifier;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardVerifiableCertificate
extends Certificate {
    final Logger log = LoggerFactory.getLogger(CardVerifiableCertificate.class);
    byte[] encoded;
    CVCertificate cvc;
    ECParameterSpec domain = null;

    public CardVerifiableCertificate(byte[] certificate) throws CertificateException {
        super("CVC");
        try {
            TLV tlv = TLV.factory(certificate);
            this.cvc = new CVCertificate(tlv);
            int size = tlv.getSize();
            this.encoded = new byte[size];
            System.arraycopy(certificate, 0, this.encoded, 0, size);
        }
        catch (TLVEncodingException e) {
            this.log.error("Decoding CVC failed with ", (Throwable)e);
            throw new CertificateParsingException(e);
        }
    }

    @Override
    public byte[] getEncoded() throws CertificateEncodingException {
        return this.encoded;
    }

    public static String algoForOID(ObjectIdentifier oid) {
        if (ECPublicKeyTLV.ID_TA_ECDSA_SHA_256.equals(oid)) {
            return "SHA256withECDSA";
        }
        if (ECPublicKeyTLV.ID_TA_ECDSA_SHA_384.equals(oid)) {
            return "SHA384withECDSA";
        }
        if (ECPublicKeyTLV.ID_TA_ECDSA_SHA_512.equals(oid)) {
            return "SHA512withECDSA";
        }
        if (ECPublicKeyTLV.ID_TA_ECDSA_SHA_224.equals(oid)) {
            return "SHA224withECDSA";
        }
        if (ECPublicKeyTLV.ID_TA_ECDSA_SHA_1.equals(oid)) {
            return "SHA1withECDSA";
        }
        return null;
    }

    @Override
    public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(key, (String)null);
    }

    public void verify(PublicKey key, String algo, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature verifier = sigProvider == null ? Signature.getInstance(algo) : Signature.getInstance(algo, sigProvider);
        verifier.initVerify(key);
        verifier.update(this.cvc.getCertificateBody().getBytes());
        byte[] wrappedSignature = ECPublicKeyTLV.wrapSignature(this.cvc.getSignatureTLV().getValue());
        boolean verified = verifier.verify(wrappedSignature);
        if (!verified) {
            throw new CertificateException("Certificate verification failed.");
        }
        this.domain = ((ECPublicKey)key).getParams();
    }

    @Override
    public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(key, "SHA256withECDSA", sigProvider);
    }

    @Override
    public String toString() {
        return this.cvc.dump();
    }

    @Override
    public PublicKey getPublicKey() {
        return this.cvc.getCertificateBody().getPublicKeyTLV().getPublicKey(this.domain);
    }

    public CertificationAuthorityReference getCertificationAuthorityReference() {
        return this.cvc.getCertificateBody().getCertificationAuthorityReference();
    }

    public CertificateHolderReference getCertificateHolderReference() {
        return this.cvc.getCertificateBody().getCertificateHolderReference();
    }
}

