/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.service;

import java.util.Hashtable;
import opencard.core.OpenCardRuntimeException;
import opencard.core.event.CTListener;
import opencard.core.event.CardTerminalEvent;
import opencard.core.event.EventGenerator;
import opencard.core.service.CardChannel;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.CardServiceRegistry;
import opencard.core.service.CardType;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.SlotChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CardServiceScheduler
implements CTListener {
    private static final Logger logger = LoggerFactory.getLogger(CardServiceScheduler.class);
    private SlotChannel slot_channel = null;
    private int card_slot = 0;
    private CardTerminal card_terminal = null;
    private CardChannel current_channel = null;
    private int smartcard_refs = 0;
    private boolean is_alive = false;
    private CardChannel free_channel = null;
    @Deprecated
    private boolean is_customized = false;
    private Hashtable card_types = new Hashtable();
    private int threads = 0;

    public CardServiceScheduler(SlotChannel slotchannel) {
        logger.debug("[init] slotChannel " + slotchannel);
        this.slot_channel = slotchannel;
        this.card_terminal = slotchannel.getCardTerminal();
        this.card_slot = slotchannel.getSlotNumber();
        this.is_alive = true;
        this.free_channel = new CardChannel(slotchannel);
        EventGenerator.getGenerator().addCTListener(this);
    }

    @Deprecated
    public void setCustomChannel(CardChannel channel) throws InvalidCardChannelException {
        if (this.is_customized) {
            throw new InvalidCardChannelException("scheduler already customized");
        }
        if (this.free_channel == null) {
            throw new InvalidCardChannelException("channel in use");
        }
        this.free_channel.closeFinal();
        this.free_channel = channel;
        this.is_customized = true;
    }

    @Deprecated
    public void useDefaultChannel() throws InvalidCardChannelException {
        if (!this.is_customized) {
            return;
        }
        if (this.free_channel == null) {
            throw new InvalidCardChannelException("custom channel in use");
        }
        this.free_channel.closeFinal();
        this.free_channel = new CardChannel(this.slot_channel);
        this.is_customized = false;
    }

    @Deprecated
    public final boolean isCustomized() {
        return this.is_customized;
    }

    public final SlotChannel getSlotChannel() {
        return this.slot_channel;
    }

    public synchronized CardChannel allocateCardChannel(Object applicant, boolean block) throws CardTerminalException {
        this.assertLiveness();
        if (this.threads > 0 && !block) {
            return null;
        }
        logger.trace("[allocateCardChannel] applicant " + applicant);
        ++this.threads;
        if (this.threads > 1) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                logger.error("[allocateCardChannel]" + ie);
                --this.threads;
                return null;
            }
            if (!this.isAlive()) {
                logger.warn("[allocateCardChannel]scheduler died while waiting for CardChannel");
                return null;
            }
        }
        this.free_channel.open();
        this.current_channel = this.free_channel;
        this.free_channel = null;
        return this.current_channel;
    }

    public synchronized void releaseCardChannel(CardChannel channel) throws InvalidCardChannelException {
        logger.trace("[releaseCardChannel] releasing " + channel);
        if (this.current_channel != channel && this.is_alive) {
            throw new InvalidCardChannelException("channel not current channel");
        }
        channel.close();
        this.current_channel = null;
        this.free_channel = channel;
        --this.threads;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CardID reset(CardChannel ch, boolean warm, boolean block) throws CardTerminalException {
        boolean release = false;
        try {
            if (ch == null) {
                ch = this.allocateCardChannel(this, block);
                release = true;
            }
            if (ch == null) {
                CardID cardID = null;
                return cardID;
            }
            CardID id = this.slot_channel.reset(warm);
            ch.setState(null);
            CardID cardID = id;
            return cardID;
        }
        finally {
            if (release) {
                this.releaseCardChannel(ch);
            }
        }
    }

    @Override
    public void cardInserted(CardTerminalEvent ctEvent) {
    }

    @Override
    public void cardRemoved(CardTerminalEvent ctEvent) throws CardTerminalException {
        if (ctEvent.getSlotID() == this.card_slot && ctEvent.getCardTerminal() == this.card_terminal) {
            logger.debug("[cardRemoved] event " + ctEvent);
            this.closeDown();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(", ").append(this.is_alive ? "is" : "not").append(" alive");
        if (this.threads > 0) {
            sb.append("\n++  channel is allocated");
        }
        if (this.threads > 1) {
            sb.append("\n++ " + (this.threads - 1) + " threads waiting for channel");
        }
        return sb.toString();
    }

    protected final boolean isAlive() throws CardTerminalException {
        if (this.is_alive && (this.slot_channel == null || !this.slot_channel.isOpen())) {
            this.closeDown();
        }
        return this.is_alive;
    }

    protected synchronized SmartCard createSmartCard(CardID cid) throws CardTerminalException {
        logger.debug("[createSmartCard] creating SmartCard");
        SmartCard card = null;
        try {
            this.assertLiveness();
            card = new SmartCard(this, cid);
            ++this.smartcard_refs;
        }
        catch (OpenCardRuntimeException ocre) {
            logger.debug("[createSmartCard] could not create SmartCard");
        }
        return card;
    }

    protected synchronized void releaseSmartCard(SmartCard card) throws CardTerminalException {
        logger.debug("[releaseSmartCard] releasing " + card);
        --this.smartcard_refs;
        if (this.smartcard_refs < 1) {
            logger.info("[releaseSmartCard] no more SmartCards, closing down");
            this.closeDown();
        }
    }

    void setCardTypeFor(CardServiceFactory factory, CardType type) {
        this.card_types.put(factory, type);
    }

    CardType getCardTypeFor(CardServiceFactory factory) {
        return (CardType)this.card_types.get(factory);
    }

    private void assertLiveness() throws CardTerminalException {
        if (!this.isAlive()) {
            throw new InvalidCardChannelException("CardServiceScheduler dead");
        }
    }

    synchronized void closeDown() throws CardTerminalException {
        logger.debug("[closeDown] closing down scheduler");
        if (!this.is_alive) {
            return;
        }
        CardServiceRegistry.getRegistry().releaseScheduler(this);
        this.is_alive = false;
        if (this.current_channel != null) {
            logger.warn("[closeDown] closing " + this.current_channel);
            this.releaseCardChannel(this.current_channel);
        }
        this.free_channel.closeFinal();
        EventGenerator.getGenerator().removeCTListener(this);
        if (this.slot_channel.isOpen()) {
            this.slot_channel.close();
            this.slot_channel = null;
        }
        this.notifyAll();
    }
}

