/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.applet;

import opencard.core.service.CardChannel;
import opencard.core.service.CardServiceException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.opt.applet.AppletID;
import opencard.opt.applet.AppletInfo;
import opencard.opt.applet.AppletSelector;
import opencard.opt.service.CardServiceUnexpectedResponseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ISOAppletSelector
implements AppletSelector {
    protected static final byte SELECT_CLASS = 0;
    protected static final byte SELECT_INS = -92;
    protected static final byte SELECT_P1 = 4;
    protected static final byte SELECT_P2 = 0;
    protected static final short SW_OK = -28672;
    protected static final byte SELECT_SW1_WARNING = 98;
    protected static final byte SELECT_SW1_ERROR = 106;
    protected static final byte SELECT_SW2_INVALID = -125;
    protected static final byte SELECT_SW2_UNFORMAT = -124;
    protected static final byte SELECT_SW2_UNSUPPORTED = -127;
    protected static final byte SELECT_SW2_NOTFOUND = -126;
    protected static final byte SELECT_SW2_INCORRECTP1P2 = -122;
    protected static final byte SELECT_SW2_INCORRECTLC = -121;
    protected static final int MAX_APDU_SIZE = 192;
    private static final Logger logger = LoggerFactory.getLogger(ISOAppletSelector.class);

    @Override
    public synchronized AppletInfo selectApplet(CardChannel channel, AppletID appletID) throws CardTerminalException, CardServiceException {
        CommandAPDU selectCommand = null;
        ResponseAPDU selectResponse = null;
        AppletInfo result = null;
        if (channel == null) {
            throw new CardServiceException("selectApplet: No CardChannel!");
        }
        logger.debug("[selectApplet] selecting " + appletID);
        selectCommand = new CommandAPDU(6 + appletID.getBytes().length);
        selectCommand.setLength(0);
        selectCommand.append((byte)0);
        selectCommand.append((byte)-92);
        selectCommand.append((byte)4);
        selectCommand.append((byte)0);
        selectCommand.append((byte)appletID.getBytes().length);
        selectCommand.append(appletID.getBytes());
        selectResponse = channel.sendCommandAPDU(selectCommand);
        logger.debug("[selectApplet]Selection response sw = 0x" + Integer.toHexString(selectResponse.sw()));
        switch ((short)(selectResponse.sw() & 0xFFFF)) {
            case -28672: {
                result = new AppletInfo();
                result.setAppletID(appletID);
                result.setData(selectResponse);
                break;
            }
            default: {
                throw new CardServiceUnexpectedResponseException("Status Words are 0x" + Integer.toHexString((short)(selectResponse.sw() & 0xFFFF)));
            }
        }
        return result;
    }
}

