/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.service.isocard;

import opencard.opt.iso.fs.CardFileInfo;
import opencard.opt.util.TLV;
import opencard.opt.util.Tag;

public class IsoFileControlInformation
implements CardFileInfo {
    private static final Tag tagFCPUSED = new Tag(0, 2, false);
    private static final Tag tagFCPSTRUCTURAL = new Tag(1, 2, false);
    private static final Tag tagFCPFILETYPE = new Tag(2, 2, false);
    private static final Tag tagFCPFID = new Tag(3, 2, false);
    private static final Tag tagFCPPROPRIETARY = new Tag(5, 2, false);
    byte[] fci = null;
    int filelength = -1;
    short fileid = (short)-1;
    int filetype = 8;
    int recordsize = -1;
    byte[] proprietary = null;

    public IsoFileControlInformation() {
    }

    public IsoFileControlInformation(byte[] newfci) {
        this.fci = newfci;
        try {
            TLV fcp = new TLV(this.fci);
            TLV cursor = null;
            while ((cursor = fcp.findTag(null, cursor)) != null) {
                if (cursor.tag().isConstructed()) {
                    if (!cursor.tag().equals(tagFCPPROPRIETARY)) continue;
                    this.proprietary = cursor.toBinary();
                    continue;
                }
                if (cursor.tag().equals(tagFCPUSED)) {
                    this.filelength = cursor.valueAsNumber();
                    continue;
                }
                if (cursor.tag().equals(tagFCPFILETYPE)) {
                    byte[] tb = cursor.valueAsByteArray();
                    this.filetype = tb[0] & 7;
                    if (tb.length >= 3) {
                        this.recordsize = tb[2];
                    }
                    if (tb.length < 4) continue;
                    this.recordsize = (this.recordsize << 8) + tb[3];
                    continue;
                }
                if (cursor.tag().equals(tagFCPSTRUCTURAL)) {
                    if (this.filelength != -1) continue;
                    this.filelength = cursor.valueAsNumber();
                    continue;
                }
                if (cursor.tag().equals(tagFCPFID)) {
                    this.fileid = (short)cursor.valueAsNumber();
                    continue;
                }
                if (!cursor.tag().equals(tagFCPPROPRIETARY)) continue;
                this.proprietary = cursor.valueAsByteArray();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public short getFileID() {
        return this.fileid;
    }

    @Override
    public boolean isDirectory() {
        return this.filetype == 0;
    }

    @Override
    public boolean isTransparent() {
        return this.filetype == 1;
    }

    @Override
    public boolean isCyclic() {
        return (this.filetype & 6) == 6;
    }

    @Override
    public boolean isVariable() {
        return (this.filetype & 6) == 4;
    }

    @Override
    public int getLength() {
        return this.filelength;
    }

    @Override
    public int getRecordSize() {
        return this.recordsize;
    }

    @Override
    public byte[] getHeader() {
        return this.fci;
    }

    public byte[] getProprietary() {
        return this.proprietary;
    }
}

