/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.tlv.cvc;

import java.util.Arrays;

public class PublicKeyReference {
    private byte[] pkr;

    public PublicKeyReference(String pkrstr) {
        if (pkrstr.length() < 8) {
            throw new IllegalArgumentException("Public Key Reference must be at least 8 byte long");
        }
        this.pkr = pkrstr.getBytes();
    }

    public PublicKeyReference(byte[] pkr) {
        if (pkr.length < 8) {
            throw new IllegalArgumentException("Public Key Reference must be at least 8 byte long");
        }
        this.pkr = pkr;
    }

    public String getCountryCode() {
        byte[] cc = new byte[2];
        System.arraycopy(this.pkr, 0, cc, 0, 2);
        return new String(cc);
    }

    public String getMnemonic() {
        int len = this.pkr.length - 7;
        byte[] mne = new byte[len];
        System.arraycopy(this.pkr, 2, mne, 0, len);
        return new String(mne);
    }

    public String getSequenceNo() {
        byte[] seq = new byte[5];
        System.arraycopy(this.pkr, this.pkr.length - 5, seq, 0, 5);
        return new String(seq);
    }

    public String getHolder() {
        int len = this.pkr.length - 5;
        byte[] hol = new byte[len];
        System.arraycopy(this.pkr, 0, hol, 0, len);
        return new String(hol);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof PublicKeyReference)) {
            return false;
        }
        PublicKeyReference ref = (PublicKeyReference)o;
        return Arrays.equals(this.pkr, ref.pkr);
    }

    public String toString() {
        return new String(this.pkr);
    }
}

