/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.cli;

import de.cardcontact.cli.CardUpdaterLog;
import de.cardcontact.cli.ReaderConfigurationModel;
import de.cardcontact.opencard.service.CardServiceUnexpectedStatusWordException;
import de.cardcontact.opencard.service.isocard.CHVCardServiceWithControl;
import de.cardcontact.opencard.service.remoteclient.RemoteNotificationListener;
import de.cardcontact.opencard.service.remoteclient.RemoteUpdateService;
import opencard.core.event.CTListener;
import opencard.core.event.CardTerminalEvent;
import opencard.core.event.EventGenerator;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceInvalidCredentialException;
import opencard.core.service.CardServiceOperationFailedException;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.opt.security.CHVCardService;

public class CardConnectorDaemon
implements Runnable,
CTListener,
RemoteNotificationListener {
    ReaderConfigurationModel readerConfig;
    CardUpdaterLog logger;
    int lastMessageId = 0;
    boolean ensurePIN = false;
    byte[] presetPIN = null;
    SmartCard card = null;
    String url = null;
    String session = null;
    String id = "unknown";
    RemoteUpdateService rus;

    public CardConnectorDaemon(CardUpdaterLog logger, ReaderConfigurationModel readerConfig, SmartCard card) {
        this.logger = logger;
        this.readerConfig = readerConfig;
        this.card = card;
    }

    public void log(int level, String msg) {
        this.logger.log(level, msg);
    }

    static String PINStatusString(CHVCardServiceWithControl.PasswordStatus pws) {
        switch (pws) {
            case VERIFIED: {
                return "PIN verified";
            }
            case NOTVERIFIED: {
                return "PIN not verified";
            }
            case BLOCKED: {
                return "PIN is blocked";
            }
            case LASTTRY: {
                return "Last PIN try";
            }
            case NOTINITIALIZED: {
                return "PIN not initialized";
            }
            case RETRYCOUNTERLOW: {
                return "PIn retry counter low";
            }
            case TRANSPORTMODE: {
                return "PIN in transport mode";
            }
        }
        return "Unknown";
    }

    public void setPIN(byte[] pin) {
        this.presetPIN = pin;
    }

    public void setEnsurePIN(boolean ensurePIN) {
        this.ensurePIN = ensurePIN;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public void setID(String id) {
        this.id = id;
    }

    public void setSession(String session) {
        this.session = session;
    }

    void ensurePINVerification(SmartCard sc, int chvNumber) throws CardServiceException, ClassNotFoundException, CardTerminalException {
        CHVCardService chv = (CHVCardService)((Object)sc.getCardService(CHVCardService.class, true));
        boolean verified = true;
        try {
            if (chv instanceof CHVCardServiceWithControl) {
                CHVCardServiceWithControl chvcc = (CHVCardServiceWithControl)chv;
                CHVCardServiceWithControl.PasswordStatus pws = null;
                try {
                    pws = chvcc.getPasswordStatus(null, chvNumber);
                }
                catch (CardServiceUnexpectedStatusWordException e) {
                    this.log(1, "Unexpected SW1/SW2 received from card. Supported card in reader ?");
                    return;
                }
                if (pws == CHVCardServiceWithControl.PasswordStatus.BLOCKED || pws == CHVCardServiceWithControl.PasswordStatus.NOTINITIALIZED) {
                    this.log(1, CardConnectorDaemon.PINStatusString(pws));
                    return;
                }
                if (pws != CHVCardServiceWithControl.PasswordStatus.VERIFIED) {
                    try {
                        verified = chvcc.verifyPassword(null, chvNumber, this.presetPIN);
                    }
                    catch (CardServiceUnexpectedStatusWordException e) {
                        this.log(1, "PIN verification failed: " + e.getMessage());
                    }
                }
            } else {
                verified = chv.verifyPassword(null, chvNumber, this.presetPIN);
            }
            this.log(1, "PIN verified: " + verified);
        }
        catch (CardServiceInvalidCredentialException | CardServiceOperationFailedException e) {
            this.log(1, "PIN verification cancelled by user");
        }
    }

    @Override
    public void cardInserted(CardTerminalEvent ctEvent) throws CardTerminalException {
    }

    public void closeCard() {
        this.rus.cancel();
        this.card = null;
    }

    @Override
    public void cardRemoved(CardTerminalEvent ctEvent) throws CardTerminalException {
        CardTerminal ct;
        if (this.card != null && (ct = this.card.getCardID().getCardTerminal()) != null && ctEvent.getCardTerminal().equals(ct)) {
            this.closeCard();
            this.log(1, "Card removed");
        }
    }

    @Override
    public void remoteNotify(int id, String message, int ttc) {
        this.lastMessageId = id;
        this.log(1, message);
    }

    @Override
    public void run() {
        EventGenerator.getGenerator().addCTListener(this);
        String ctname = this.card.getCardID().getCardTerminal().getName();
        try {
            if (this.ensurePIN) {
                this.ensurePINVerification(this.card, 1);
            }
            this.rus = (RemoteUpdateService)((Object)this.card.getCardService(RemoteUpdateService.class, true));
            if (this.rus == null) {
                this.log(1, "No remote update service available");
            } else {
                this.log(1, "Connecting to " + this.url);
                this.rus.update(this.url, this.session, this);
                this.log(1, "Connection of token " + this.id + " to " + this.url + " completed");
            }
        }
        catch (Exception e) {
            this.log(1, "Remote connection failed with " + e.getMessage());
        }
        finally {
            if (this.readerConfig != null) {
                this.readerConfig.approveTerminal(ctname);
            }
            EventGenerator.getGenerator().removeCTListener(this);
        }
    }
}

