/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.service.smartcardhsm;

import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECPoint;
import opencard.opt.security.PrivateKeyRef;

public class SmartCardHSMPrivateKey
extends SmartCardHSMKey
implements PrivateKeyRef {
    private static final long serialVersionUID = -6946107286497965496L;

    public SmartCardHSMPrivateKey(byte keyRef, String label, short keySize, String algorithm) {
        super(keyRef, label, keySize, algorithm);
    }

    public void deriveKeySizeFromPublicKey(Certificate cert) {
        byte[] component;
        PublicKey pk = cert.getPublicKey();
        if (pk instanceof RSAPublicKey) {
            RSAPublicKey rsaPK = (RSAPublicKey)pk;
            component = rsaPK.getModulus().toByteArray();
        } else if (pk instanceof ECPublicKey) {
            ECPublicKey ecPK = (ECPublicKey)pk;
            ECPoint w = ecPK.getW();
            component = w.getAffineX().toByteArray();
        } else {
            return;
        }
        if (component[0] == 0) {
            this.setKeySize((short)((component.length - 1) * 8));
        } else {
            this.setKeySize((short)(component.length * 8));
        }
    }
}

