/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;

public class SystemAccess {
    private static SystemAccess _theSystem = new SystemAccess();
    private static Hashtable<Thread, SystemAccess> _registeredSystems = new Hashtable();

    public boolean getBoolean(String key) {
        return Boolean.getBoolean(key);
    }

    public Properties getProperties() {
        return System.getProperties();
    }

    public String getProperty(String key) {
        return System.getProperty(key);
    }

    public String getProperty(String key, String def) {
        return System.getProperty(key, def);
    }

    public static SystemAccess getSystemAccess() {
        SystemAccess sys = _registeredSystems.get(Thread.currentThread());
        if (sys == null) {
            return _theSystem;
        }
        return sys;
    }

    public void loadLibrary(String libName) {
        String arch = System.getProperty("os.arch");
        System.loadLibrary(libName + "-" + arch);
    }

    public Properties loadProperties(String filename) throws FileNotFoundException, IOException {
        Properties props = new Properties();
        props.load(new FileInputStream(new File(filename)));
        return props;
    }

    public static void setSystemAccess(SystemAccess newSystemAccess) {
        _registeredSystems.put(Thread.currentThread(), newSystemAccess);
    }
}

