/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.terminal;

import java.util.HashSet;
import opencard.core.service.CardIDFilter;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminal;

public class TerminalSelector
implements CardIDFilter {
    private String[] readerList;

    public TerminalSelector(String selector) {
        this.readerList = selector.split("\\s*;\\s*");
        if (this.readerList.length == 1 && this.readerList[0].length() == 0) {
            this.readerList = new String[0];
        }
    }

    public String getFirstSelectedTerminal() {
        for (String sel : this.readerList) {
            if (sel.length() <= 0 || sel.charAt(0) == '!') continue;
            return sel;
        }
        return null;
    }

    public HashSet<String> getSelectedReader() {
        HashSet<String> readerSet = new HashSet<String>();
        for (String sel : this.readerList) {
            if (sel.length() <= 0 || sel.charAt(0) == '!') continue;
            readerSet.add(sel);
        }
        return readerSet;
    }

    public HashSet<String> getDeselectedReader() {
        HashSet<String> readerSet = new HashSet<String>();
        for (String sel : this.readerList) {
            if (sel.length() <= 0 || sel.charAt(0) != '!') continue;
            readerSet.add(sel.substring(1));
        }
        return readerSet;
    }

    public boolean isEmpty() {
        return this.readerList.length == 0;
    }

    @Override
    public boolean isCandidate(CardID cardID) {
        CardTerminal ct = cardID.getCardTerminal();
        String readerName = "";
        if (ct != null) {
            readerName = ct.getName();
        }
        boolean result = true;
        for (String sel : this.readerList) {
            if (sel.length() > 0 && sel.charAt(0) == '!') {
                if (!readerName.startsWith(sel = sel.substring(1))) continue;
                return false;
            }
            if (readerName.startsWith(sel)) {
                return true;
            }
            result = false;
        }
        return result;
    }
}

