/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.service.remoteclient;

import de.cardcontact.opencard.service.remoteclient.RemoteNotificationListener;
import de.cardcontact.opencard.service.remoteclient.RemoteProtocolEncoder;
import de.cardcontact.opencard.service.remoteclient.RemoteProtocolUnit;
import de.cardcontact.tlv.TLVDataSizeException;
import de.cardcontact.tlv.TLVEncodingException;
import de.cardcontact.tlv.TagSizeException;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import opencard.core.OpenCardException;
import opencard.core.service.CardService;
import opencard.core.service.CardServiceException;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.opt.util.APDUInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteClient {
    private static final Logger logger = LoggerFactory.getLogger(RemoteClient.class);
    private HttpURLConnection connection;
    private String session = null;
    private String contentType = "application/org.openscdp-content-mgt-response;version=1.0";
    private CardService cardService;

    public RemoteClient(CardService cardService) {
        if (!(cardService instanceof APDUInterface)) {
            throw new RuntimeException("CardService must implement the APDUInterface");
        }
        this.cardService = cardService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFully(HttpURLConnection connection) throws IOException {
        int resplen = connection.getContentLength();
        if (resplen <= 0) {
            return null;
        }
        byte[] resp = new byte[resplen];
        try (InputStream is = connection.getInputStream();){
            int offset = 0;
            int bread = 0;
            while (resplen > 0 && (bread = is.read(resp, offset, resplen)) != -1) {
                offset += bread;
                resplen -= bread;
            }
        }
        return resp;
    }

    private byte[] initialConnect(String serverURL) throws IOException, TLVEncodingException {
        byte[] data;
        URL url = new URL(serverURL);
        this.connection = (HttpURLConnection)url.openConnection();
        this.connection.setDoInput(true);
        this.connection.setDoOutput(true);
        this.connection.setRequestMethod("POST");
        this.connection.setRequestProperty("Content-Type", this.contentType);
        if (this.session != null) {
            this.connection.addRequestProperty("Cookie", this.session);
        }
        RemoteProtocolEncoder rpe = new RemoteProtocolEncoder();
        rpe.add(new RemoteProtocolUnit(this.cardService.getCard().getCardID()));
        OutputStream writer = this.connection.getOutputStream();
        writer.write(rpe.encodeInitiationTemplate());
        writer.close();
        String cookie = this.connection.getHeaderField("Set-Cookie");
        if (cookie != null) {
            this.session = cookie.split(";")[0];
        }
        if ((data = this.readFully(this.connection)) == null) {
            throw new CardServiceException("No data received from server. HTTP code " + this.connection.getResponseCode() + " " + this.connection.getResponseMessage());
        }
        return data;
    }

    private byte[] processNext(String serverURL, byte[] rst) throws IOException, TLVEncodingException, TagSizeException, TLVDataSizeException {
        URL url = new URL(serverURL);
        this.connection = (HttpURLConnection)url.openConnection();
        this.connection.setDoInput(true);
        this.connection.setDoOutput(true);
        this.connection.setRequestMethod("POST");
        this.connection.addRequestProperty("Cookie", this.session);
        this.connection.setRequestProperty("Content-Type", this.contentType);
        DataOutputStream writer = new DataOutputStream(this.connection.getOutputStream());
        writer.write(rst);
        writer.close();
        return this.readFully(this.connection);
    }

    private RemoteProtocolUnit sendCommandAPDU(RemoteProtocolUnit rpu) throws OpenCardException {
        CommandAPDU capdu = (CommandAPDU)rpu.getPayload();
        ResponseAPDU res = ((APDUInterface)((Object)this.cardService)).sendCommandAPDU(capdu);
        return new RemoteProtocolUnit(res);
    }

    private RemoteProtocolUnit resetCard(RemoteProtocolUnit rpu) throws CardTerminalException {
        CardID cid = this.cardService.getCard().reset(false);
        if (cid == null) {
            throw new CardTerminalException("Could not reset card");
        }
        return new RemoteProtocolUnit(cid);
    }

    private byte[] process(byte[] cst, RemoteNotificationListener notificationListener) throws TLVEncodingException {
        RemoteProtocolEncoder rpe = new RemoteProtocolEncoder();
        rpe.decodeCommandScriptingTemplate(cst);
        List<RemoteProtocolUnit> rpus = rpe.getRemoteProtocolUnits();
        rpe = new RemoteProtocolEncoder();
        int apdus = 0;
        try {
            for (RemoteProtocolUnit rpu : rpus) {
                switch (rpu.getAction()) {
                    case APDU: {
                        rpe.add(this.sendCommandAPDU(rpu));
                        ++apdus;
                        break;
                    }
                    case RESET: {
                        rpe.add(this.resetCard(rpu));
                        break;
                    }
                    case NOTIFY: {
                        if (notificationListener == null) break;
                        notificationListener.remoteNotify(rpu.getId(), rpu.getMessage(), rpu.getTimeToCompletion());
                        break;
                    }
                }
            }
        }
        catch (OpenCardException cte) {
            rpe.add(new RemoteProtocolUnit(RemoteProtocolUnit.Action.CLOSE, -1, cte.toString()));
        }
        rpe.setExecutedCommands(apdus);
        return rpe.encodeResponseScriptingTemplate();
    }

    public void update(String serverURL, String sessionId, RemoteNotificationListener notificationListener) throws CardServiceException {
        if (sessionId != null) {
            this.session = sessionId.contains("=") ? sessionId : "JSESSIONID=" + sessionId;
        }
        try {
            byte[] cst = this.initialConnect(serverURL);
            int code = this.connection.getResponseCode();
            while (code == 200) {
                byte[] rst = this.process(cst, notificationListener);
                cst = this.processNext(serverURL, rst);
                code = this.connection.getResponseCode();
                logger.debug("HTTP Code " + code);
            }
            if (code != 204) {
                throw new CardServiceException("Connection to " + serverURL + " failed with HTTP code " + code);
            }
            logger.debug("Session " + this.session + " completed");
        }
        catch (FileNotFoundException e) {
            throw new CardServiceException("URL " + serverURL + " not found");
        }
        catch (IOException e) {
            throw new CardServiceException("IO error during connection to " + serverURL + "(" + e.toString() + ")");
        }
        catch (TLVEncodingException e) {
            throw new CardServiceException(e.toString());
        }
        catch (TagSizeException e) {
            throw new CardServiceException(e.toString());
        }
        catch (TLVDataSizeException e) {
            throw new CardServiceException(e.toString());
        }
    }
}

