/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.cli;

import de.cardcontact.cli.CardUpdaterDaemon;
import de.cardcontact.cli.CardUpdaterLog;
import de.cardcontact.cli.TerminalManager;
import de.cardcontact.cli.TrayView;
import de.cardcontact.cli.URLVerifier;
import de.cardcontact.opencard.factory.IsoCardServiceFactory;
import de.cardcontact.opencard.factory.RemoteClientCardServiceFactory;
import de.cardcontact.opencard.factory.SmartCardHSMCardServiceFactory;
import de.cardcontact.opencard.service.isocard.CHVCardServiceWithControl;
import de.cardcontact.opencard.service.remoteclient.RemoteClientCardService;
import de.cardcontact.opencard.service.remoteclient.RemoteNotificationListener;
import de.cardcontact.opencard.terminal.smartcardio.SmartCardIOFactory;
import de.cardcontact.opencard.utils.StreamingAPDUTracer;
import java.util.Enumeration;
import opencard.core.OpenCardException;
import opencard.core.service.CardRequest;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.CardServiceRegistry;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.opt.security.CHVCardService;

public class CardUpdater
implements RemoteNotificationListener,
CardUpdaterLog {
    private String readerName = null;
    private String url = null;
    private String session = null;
    private byte[] pin = null;
    private int verbose = 2;
    private int lastMessageId = 0;
    private boolean reset = true;
    private boolean listReaders = false;
    private boolean password = false;
    private boolean showLog = false;
    private TerminalManager terminalManager = new TerminalManager();

    @Override
    public void log(int level, String msg) {
        if (this.verbose >= level) {
            System.out.println(msg);
        }
    }

    @Override
    public int getVerbosityLevel() {
        return this.verbose;
    }

    @Override
    public void remoteNotify(int id, String message, int ttc) {
        this.lastMessageId = id;
        this.log(1, message);
    }

    public void setupOCF() throws OpenCardException, ClassNotFoundException {
        SmartCard.startup();
        CardTerminalRegistry ctr = CardTerminalRegistry.getRegistry();
        SmartCardIOFactory ctf = new SmartCardIOFactory();
        String[] param = new String[]{"*", "PCSC"};
        ctf.createCardTerminals(ctr, param);
        CardServiceRegistry csr = CardServiceRegistry.getRegistry();
        CardServiceFactory csf = new RemoteClientCardServiceFactory();
        csr.add(csf);
        csf = new SmartCardHSMCardServiceFactory();
        csr.add(csf);
        csf = new IsoCardServiceFactory();
        csr.add(csf);
    }

    public void help() {
        System.out.println("Usage: java -jar ocf-cc.jar [-r <readername>] [-s <id>] [-n] [-l] [-w] [-v] [<url>]\n");
        System.out.println("-n\t\tNo card reset at end of session");
        System.out.println("-s <id>\t\tSession id");
        System.out.println("-n\t\tNo reset at end of session");
        System.out.println("-w\t\tOpen log window");
        System.out.println("-l\t\tList reader names");
        System.out.println("-v\t\tVerbose");
        System.out.println("-q\t\tQuiet");
        System.out.println("-p\t\tPassword verification");
        System.out.println("An URL on the command line deactivates the daemon mode and connects directly with that URL");
    }

    public boolean decodeArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-r")) {
                this.readerName = args[++i];
                continue;
            }
            if (args[i].equals("-s")) {
                this.session = args[++i];
                continue;
            }
            if (args[i].equals("-v")) {
                ++this.verbose;
                continue;
            }
            if (args[i].equals("-q")) {
                --this.verbose;
                continue;
            }
            if (args[i].equals("-n")) {
                this.reset = false;
                continue;
            }
            if (args[i].equals("-l")) {
                this.listReaders = true;
                continue;
            }
            if (args[i].equals("-w")) {
                this.showLog = true;
                continue;
            }
            if (args[i].equals("-p")) {
                this.password = true;
                if (i >= args.length || args[i + 1].startsWith("-")) continue;
                this.pin = args[++i].getBytes();
                continue;
            }
            if (args[i].charAt(0) == '-') {
                this.log(1, "Unknown option " + args[i]);
                return false;
            }
            this.url = args[i];
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String[] args) {
        if (!this.decodeArgs(args)) {
            this.help();
            System.exit(1);
        }
        try {
            this.setupOCF();
            this.log(1, SmartCard.getVersion());
            if (this.listReaders) {
                CardTerminalRegistry ctr = CardTerminalRegistry.getRegistry();
                Enumeration ctlist = ctr.getCardTerminals();
                if (this.listReaders) {
                    System.out.println("Available card terminals:");
                    while (ctlist.hasMoreElements()) {
                        CardTerminal ct = (CardTerminal)ctlist.nextElement();
                        System.out.println(" " + ct.getName());
                    }
                    System.out.println("");
                }
            } else {
                CardTerminal ct = null;
                CardTerminalRegistry ctr = CardTerminalRegistry.getRegistry();
                if (this.readerName != null) {
                    ct = ctr.cardTerminalForName(this.readerName);
                    if (ct == null) {
                        this.log(1, "Card reader " + this.readerName + " not found");
                        System.exit(1);
                    }
                    this.log(1, "Using reader " + this.readerName);
                }
                if (this.password && !this.verifyPin(ct, 1)) {
                    this.log(1, "PIN not verified");
                    System.exit(1);
                }
                if (this.url == null) {
                    if (this.readerName != null) {
                        this.terminalManager.setSelectedTerminal(this.readerName);
                    }
                    CardUpdaterDaemon updaterDaemon = new CardUpdaterDaemon(this, this.terminalManager, new URLVerifier());
                    if (this.pin != null) {
                        updaterDaemon.setPIN(this.pin);
                    }
                    TrayView view = new TrayView(this.terminalManager);
                    if (this.showLog) {
                        view.showLog();
                    }
                    Thread daemonThread = new Thread(updaterDaemon);
                    daemonThread.setDaemon(true);
                    daemonThread.start();
                } else {
                    this.log(1, "Connecting to " + this.url);
                    CardRequest cr = new CardRequest(1, ct, RemoteClientCardService.class);
                    cr.setTimeout(0);
                    cr.setFilter(this.terminalManager);
                    SmartCard sc = SmartCard.waitForCard(cr);
                    if (sc == null) {
                        this.log(1, "No card in reader");
                    } else {
                        RemoteClientCardService rc = (RemoteClientCardService)sc.getCardService(RemoteClientCardService.class, true);
                        sc.setAPDUTracer(new StreamingAPDUTracer(System.out));
                        rc.update(this.url, this.session, this);
                        this.log(1, "Update complete");
                        if (this.reset) {
                            sc.reset(false);
                        }
                        sc.close();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.lastMessageId = -1;
        }
        finally {
            try {
                if (this.url != null) {
                    SmartCard.shutdown();
                }
            }
            catch (Exception exception) {}
        }
    }

    private boolean verifyPin(CardTerminal ct, int chvNumber) throws CardTerminalException, CardServiceException, ClassNotFoundException {
        CHVCardServiceWithControl.PasswordStatus pws;
        CardRequest creq = new CardRequest(1, ct, CHVCardService.class);
        creq.setTimeout(0);
        SmartCard card = SmartCard.waitForCard(creq);
        if (card == null) {
            this.log(1, "No card in reader");
            return false;
        }
        CHVCardService chv = (CHVCardService)((Object)card.getCardService(CHVCardService.class, true));
        if (chv instanceof CHVCardServiceWithControl && ((pws = ((CHVCardServiceWithControl)chv).getPasswordStatus(null, chvNumber)) == CHVCardServiceWithControl.PasswordStatus.BLOCKED || pws == CHVCardServiceWithControl.PasswordStatus.NOTINITIALIZED || pws == CHVCardServiceWithControl.PasswordStatus.TRANSPORTMODE)) {
            this.log(1, CardUpdaterDaemon.PINStatusString(pws));
            return false;
        }
        boolean verified = chv.verifyPassword(null, chvNumber, this.pin);
        this.log(1, "PIN verified: " + verified);
        return verified;
    }

    public static void main(String[] args) {
        CardUpdater cu = new CardUpdater();
        cu.run(args);
    }
}

