/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.terminal.jcopsim;

import de.cardcontact.opencard.terminal.jcopsim.JCOPSimCardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalFactory;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.TerminalInitException;

public class JCOPSimCardTerminalFactory
implements CardTerminalFactory {
    @Override
    public void createCardTerminals(CardTerminalRegistry ctr, String[] terminalInfo) throws CardTerminalException, TerminalInitException {
        String host = "localhost";
        int port = 8050;
        int timeout = 5000;
        if (terminalInfo.length < 3) {
            throw new TerminalInitException("JCOPSimCardTerminalFactory needs at least 3 parameters.");
        }
        if (!terminalInfo[1].equals("JCOPSIM")) {
            throw new TerminalInitException("Requested Terminal type not known.");
        }
        if (terminalInfo.length >= 4) {
            host = terminalInfo[3];
        }
        if (terminalInfo.length >= 5) {
            port = Integer.parseInt(terminalInfo[4]);
        }
        if (terminalInfo.length == 6) {
            timeout = Integer.parseInt(terminalInfo[5]);
        }
        try {
            ctr.add(new JCOPSimCardTerminal(terminalInfo[0], terminalInfo[1], terminalInfo[2], host, port, timeout));
        }
        catch (Exception e) {
            throw new TerminalInitException("JCOPSimCardTerminal could not be added to card terminal registry! " + e.getMessage());
        }
    }

    @Override
    public void open() throws CardTerminalException {
    }

    @Override
    public void close() throws CardTerminalException {
    }
}

