/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.ctapi;

import de.cardcontact.ctapi.CTAPITerminal;
import de.cardcontact.ctapi.ICTAPIEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CTAPI {
    public static final int OK = 0;
    public static final int ERR_INVALID = -1;
    public static final int ERR_CT = -8;
    public static final int ERR_TRANS = -10;
    public static final int ERR_MEMORY = -11;
    public static final int ERR_HOST = -127;
    public static final int ICC1 = 0;
    public static final int CT = 1;
    public static final int HOST = 2;
    public static final int ICC2 = 2;
    public static final int REMOTE_HOST = 5;
    public static final int NO_READER_NAME = 1;
    private ICTAPIEvent eventListener = null;
    private HashMap<Integer, CTAPITerminal> map = null;
    private long ctInitPointer = 0L;
    private long ctClosePointer = 0L;
    private long ctDataPointer = 0L;
    private long ctListPointer = 0L;

    public native int CT_Init(int var1, int var2);

    public native int CT_Close(int var1);

    public native int CT_Data(int var1, byte var2, byte var3, byte[] var4, int var5, byte[] var6);

    private native int CT_List_native(byte[] var1, int var2);

    private native void setCTAPILib(String var1) throws UnsatisfiedLinkError;

    public CTAPI(String libname) {
        this.setCTAPILib(System.mapLibraryName(libname));
    }

    public List<CTAPITerminal> CT_List() {
        return this.CT_List(false);
    }

    public List<CTAPITerminal> CT_List(boolean noName) {
        ArrayList<CTAPITerminal> readers = new ArrayList<CTAPITerminal>(32);
        byte[] r = new byte[4096];
        int len = this.CT_List_native(r, noName ? 1 : 0);
        if (len < 0) {
            throw new RuntimeException("Failed enumerating CT-API devices");
        }
        for (int ofs = 0; ofs < len; ++ofs) {
            int port = (r[ofs] & 0xFF) << 8 | r[ofs + 1] & 0xFF;
            int s = ofs += 2;
            while (ofs < len && r[ofs] != 0) {
                ++ofs;
            }
            byte[] namebin = new byte[ofs - s];
            System.arraycopy(r, s, namebin, 0, ofs - s);
            readers.add(new CTAPITerminal(this, port, new String(namebin)));
        }
        return readers;
    }

    public void setEventListener(ICTAPIEvent eventListener) {
        this.eventListener = eventListener;
    }

    public void checkEvent() {
        List<CTAPITerminal> terms;
        boolean termsAdded = false;
        HashMap<Integer, CTAPITerminal> newMap = new HashMap<Integer, CTAPITerminal>();
        if (this.eventListener == null) {
            throw new RuntimeException("No event listener defined");
        }
        if (this.map != null) {
            terms = this.CT_List(true);
            for (CTAPITerminal term : terms) {
                CTAPITerminal et = this.map.remove(term.getPort());
                if (et == null) {
                    termsAdded = true;
                    continue;
                }
                newMap.put(et.getPort(), et);
            }
            if (!this.map.isEmpty()) {
                terms = new ArrayList<CTAPITerminal>();
                for (CTAPITerminal t : this.map.values()) {
                    terms.add(t);
                }
                this.eventListener.terminalsRemoved(terms);
            }
        } else {
            termsAdded = true;
        }
        if (termsAdded) {
            ArrayList<CTAPITerminal> addedterms = new ArrayList<CTAPITerminal>();
            terms = this.CT_List(false);
            for (CTAPITerminal term : terms) {
                if (newMap.containsKey(term.getPort())) continue;
                newMap.put(term.getPort(), term);
                addedterms.add(term);
            }
            this.eventListener.terminalsAdded(addedterms);
        }
        this.map = newMap;
    }

    static {
        String arch = System.getProperty("os.arch");
        System.loadLibrary("ctapi-jni-" + arch);
    }
}

