/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.terminal.remoteterminal;

import de.cardcontact.opencard.service.remoteclient.RemoteCardSpec;
import de.cardcontact.opencard.service.remoteclient.RemoteProtocolUnit;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.CommunicationErrorException;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.SlotChannel;
import opencard.core.terminal.TerminalTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteTerminal
extends CardTerminal {
    private static final Logger logger = LoggerFactory.getLogger(RemoteTerminal.class);
    private static final int timeoutShort = 30;
    private static final int timeoutLong = 300;
    private boolean freshConnect = true;
    private boolean remoteWaiting = false;
    private int maxCAPDU = -1;
    private int maxRAPDU = -1;
    private CardID cardID = null;
    private LinkedBlockingQueue<RemoteProtocolUnit> comQueue = new LinkedBlockingQueue(1);
    private LinkedBlockingQueue<RemoteProtocolUnit> resQueue = new LinkedBlockingQueue(1);

    protected RemoteTerminal(String name, String type, String address) throws CardTerminalException {
        super(name, type, address);
        logger.debug("[RemoteTerminal] TERMINAL: starting " + name);
        this.addSlots(1);
    }

    protected RemoteProtocolUnit transmit(RemoteProtocolUnit cmdObject, int timeout) throws CardTerminalException {
        RemoteProtocolUnit resObject;
        try {
            if (!this.remoteWaiting) {
                Thread.sleep(1000L);
                if (!this.remoteWaiting) {
                    throw new CardTerminalException("Remote disappeared");
                }
            }
            this.comQueue.put(cmdObject);
            logger.debug("[transmit] Waiting for response");
            resObject = this.resQueue.poll(timeout, TimeUnit.SECONDS);
            if (resObject == null) {
                throw new TerminalTimeoutException("The waiting time of " + timeout + " seconds for the response has expired.", timeout);
            }
            if (resObject.isClosing()) {
                throw new CommunicationErrorException(resObject.getMessage());
            }
        }
        catch (InterruptedException e) {
            throw new CardTerminalException(e.getMessage());
        }
        return resObject;
    }

    public RemoteProtocolUnit poll(int timeout) throws CardTerminalException {
        RemoteProtocolUnit comObject;
        try {
            logger.debug("[poll] TERMINAL: Wait for APDU. Queue size" + this.comQueue.size());
            this.remoteWaiting = true;
            comObject = this.comQueue.poll(timeout, TimeUnit.SECONDS);
            if (this.freshConnect) {
                if (comObject == null) {
                    throw new CommunicationErrorException("The waiting time of " + timeout + " seconds for the initial command apdu has expired.");
                }
                this.freshConnect = false;
            }
        }
        catch (InterruptedException e) {
            throw new CardTerminalException(e.getMessage());
        }
        finally {
            this.remoteWaiting = false;
        }
        return comObject;
    }

    public void put(RemoteProtocolUnit resObject) throws CardTerminalException {
        logger.debug("[put] Put response into queue");
        try {
            this.resQueue.put(resObject);
        }
        catch (InterruptedException e) {
            throw new CardTerminalException(e.getMessage());
        }
    }

    @Override
    public CardID getCardID(int slotID) throws CardTerminalException {
        if (this.cardID != null) {
            return this.cardID;
        }
        return new CardID(this, 0, new byte[]{59, -128, 0, 0});
    }

    public void setRemoteCardSpec(RemoteCardSpec rcs) throws CardTerminalException {
        this.cardID = new CardID(this, 0, rcs.getCardID().getATR());
        this.maxCAPDU = rcs.getMaxCAPDU();
        this.maxRAPDU = rcs.getMaxRAPDU();
        this.freshConnect = true;
    }

    @Override
    protected Properties internalFeatures(Properties features) {
        if (this.maxCAPDU != -1) {
            features.put("maxCAPDUSize", String.valueOf(this.maxCAPDU));
        }
        if (this.maxRAPDU != -1) {
            features.put("maxRAPDUSize", String.valueOf(this.maxRAPDU));
        }
        return features;
    }

    public void setCardID(CardID cardID) throws CardTerminalException {
        this.cardID = new CardID(this, 0, cardID.getATR());
        this.freshConnect = true;
    }

    @Override
    public boolean isCardPresent(int slotID) throws CardTerminalException {
        return this.cardID != null;
    }

    @Override
    public void open() throws CardTerminalException {
        logger.debug("[open] open");
    }

    @Override
    public void close() throws CardTerminalException {
        logger.debug("[close] close");
        if (!this.comQueue.isEmpty()) {
            logger.debug("[close] TERMINAL: clearing com queue...");
            this.comQueue.clear();
        }
        this.comQueue.offer(new RemoteProtocolUnit(RemoteProtocolUnit.Action.CLOSE));
    }

    @Override
    protected CardID internalReset(int slot, int ms) throws CardTerminalException {
        RemoteProtocolUnit rpu = this.transmit(new RemoteProtocolUnit(RemoteProtocolUnit.Action.RESET), 30);
        if (!rpu.isRESET()) {
            throw new CardTerminalException("Received unexpected message");
        }
        this.setCardID(((RemoteCardSpec)rpu.getPayload()).getCardID());
        return this.cardID;
    }

    @Override
    protected ResponseAPDU internalSendAPDU(int slot, CommandAPDU capdu, int ms) throws CardTerminalException {
        RemoteProtocolUnit rpu;
        int timeout = 30;
        if (capdu.getByte(1) == 70 || capdu.getByte(1) == 230) {
            timeout = 300;
        }
        if (!(rpu = this.transmit(new RemoteProtocolUnit(capdu), timeout)).isAPDU()) {
            throw new CardTerminalException("Received unexpected message");
        }
        return (ResponseAPDU)rpu.getPayload();
    }

    @Override
    protected void internalCloseSlotChannel(SlotChannel sc) {
        this.cardID = null;
        try {
            if (!this.comQueue.offer(new RemoteProtocolUnit(RemoteProtocolUnit.Action.CLOSE), 2L, TimeUnit.SECONDS)) {
                logger.debug("Close message could not be added to queue");
            }
        }
        catch (InterruptedException e) {
            logger.debug("Adding close message interrupted");
        }
    }

    public void sendNotification(int id, String message, int ttc) throws CardTerminalException {
        try {
            if (!this.comQueue.offer(new RemoteProtocolUnit(RemoteProtocolUnit.Action.NOTIFY, id, message, ttc), 2L, TimeUnit.SECONDS)) {
                logger.debug("Notify message could not be added to queue");
            }
        }
        catch (InterruptedException e) {
            logger.debug("Adding notify message interrupted");
        }
    }

    public void sendNotification(int id, String message) throws CardTerminalException {
        this.sendNotification(id, message, 0);
    }
}

