/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.tlv;

import de.cardcontact.tlv.ParseBuffer;
import de.cardcontact.tlv.PrimitiveTLV;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import de.cardcontact.tlv.Tag;
import de.cardcontact.tlv.TreeNode;
import java.util.ArrayList;
import java.util.Iterator;

public class ConstructedTLV
extends TLV {
    protected ArrayList<TLV> childs = null;

    public ConstructedTLV(Tag newtag) {
        this.tag = newtag;
        this.childs = new ArrayList();
    }

    public ConstructedTLV(int tagValue) throws TLVEncodingException {
        this.tag = new Tag(tagValue);
        this.childs = new ArrayList();
    }

    private ConstructedTLV(byte[] buffer, int offset) throws TLVEncodingException {
        Tag subTag = null;
        this.childs = new ArrayList();
        this.tag = new Tag(buffer, offset);
        int length = ConstructedTLV.lengthFromByteArray(buffer, offset += this.tag.getSize(), this.alternateLengthFormat);
        int limit = (offset += ConstructedTLV.getLengthFieldSizeHelper(length, this.alternateLengthFormat)) + length;
        while (offset < limit) {
            subTag = new Tag(buffer, offset);
            if (subTag.isConstructed()) {
                ConstructedTLV ct = new ConstructedTLV(buffer, offset);
                offset += ct.getSize();
                this.add(ct);
                continue;
            }
            PrimitiveTLV pt = new PrimitiveTLV(buffer, offset);
            offset += pt.getSize();
            this.add(pt);
        }
    }

    public ConstructedTLV(ParseBuffer pb) throws TLVEncodingException {
        this.childs = new ArrayList();
        this.tag = new Tag(pb);
        int length = this.alternateLengthFormat ? pb.getDGILength() : pb.getDERLength();
        int limit = pb.getLimit();
        if (length >= 0) {
            pb.setLength(length);
            while (pb.hasRemaining()) {
                this.add(TLV.factory(pb));
            }
        } else {
            while (true) {
                TLV t = TLV.factory(pb);
                if (t.tag.getNumber() == 0 && t.getLength() == 0) break;
                this.add(t);
            }
        }
        pb.setLimit(limit);
    }

    public ConstructedTLV(byte[] buffer) throws TLVEncodingException {
        this(new ParseBuffer(buffer));
    }

    public ConstructedTLV(TLV tlv) throws UnsupportedOperationException {
        super(tlv);
        if (!(tlv instanceof ConstructedTLV)) {
            throw new UnsupportedOperationException("Can not clone from other than constructed TLV");
        }
        this.childs = ((ConstructedTLV)tlv).childs;
    }

    @Override
    protected int valueToByteArray(byte[] buffer, int offset) {
        Iterator<TLV> iter = this.childs.iterator();
        while (iter.hasNext()) {
            offset = iter.next().toByteArray(buffer, offset);
        }
        return offset;
    }

    @Override
    protected int toByteArray(byte[] buffer, int offset) {
        int length = this.getLength();
        offset = this.tag.toByteArray(buffer, offset);
        offset = ConstructedTLV.lengthToByteArray(length, buffer, offset, this.alternateLengthFormat);
        Iterator<TLV> iter = this.childs.iterator();
        while (iter.hasNext()) {
            offset = iter.next().toByteArray(buffer, offset);
        }
        return offset;
    }

    @Override
    public int getLength() {
        Iterator<TLV> iter = this.childs.iterator();
        int length = 0;
        while (iter.hasNext()) {
            length += iter.next().getSize();
        }
        return length;
    }

    public ConstructedTLV add(TLV tlv) {
        this.childs.add(tlv);
        return this;
    }

    public ConstructedTLV add(int index, TLV tlv) {
        this.childs.add(index, tlv);
        return this;
    }

    public void remove(int index) {
        this.childs.remove(index);
    }

    public TLV get(int index) {
        return this.childs.get(index);
    }

    public int getElements() {
        return this.childs.size();
    }

    public TLV findTag(Tag tag, TLV cursor) {
        int index;
        if (cursor == null) {
            index = 0;
        } else {
            index = this.childs.indexOf(cursor);
            if (index == -1) {
                return null;
            }
            ++index;
        }
        int size = this.childs.size();
        while (index < size) {
            cursor = this.childs.get(index);
            if (tag.equals(cursor.getTag())) {
                return cursor;
            }
            ++index;
        }
        return null;
    }

    @Override
    public String dump(int indent) {
        StringBuffer buffer = new StringBuffer(100);
        for (int i = 0; i < indent; ++i) {
            buffer.append(' ');
        }
        if (this.name != null) {
            buffer.append(this.name);
            buffer.append(' ');
        }
        buffer.append(this.tag.toString());
        buffer.append(" SIZE( " + this.getLength() + " )");
        buffer.append('\n');
        Iterator<TLV> iter = this.childs.iterator();
        while (iter.hasNext()) {
            buffer.append(iter.next().dump(indent + 2));
        }
        return buffer.toString();
    }

    @Override
    public int getChildCount() {
        return this.childs.size();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public TreeNode getParent() {
        return null;
    }

    @Override
    public TreeNode getChildAt(int index) {
        return this.childs.get(index);
    }

    @Override
    public int getIndex(TreeNode child) {
        return this.childs.indexOf(child);
    }
}

