/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.cli;

import de.cardcontact.cli.APDUTracerLogAdapter;
import de.cardcontact.cli.CardUpdaterLog;
import de.cardcontact.cli.URLVerifier;
import de.cardcontact.opencard.service.CardServiceUnexpectedStatusWordException;
import de.cardcontact.opencard.service.isocard.CHVCardServiceWithControl;
import de.cardcontact.opencard.service.remoteclient.RemoteClient;
import de.cardcontact.opencard.service.remoteclient.RemoteNotificationListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import opencard.core.event.CTListener;
import opencard.core.event.CardTerminalEvent;
import opencard.core.event.EventGenerator;
import opencard.core.service.CardIDFilter;
import opencard.core.service.CardRequest;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceInvalidCredentialException;
import opencard.core.service.CardServiceOperationFailedException;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.opt.security.CHVCardService;

public class CardUpdaterDaemon
implements Runnable,
CTListener,
RemoteNotificationListener {
    static final int SERVER_PORT = 27001;
    static final int closingDelay = 60;
    private CardUpdaterLog logger;
    private int lastMessageId = 0;
    private ServerSocket server;
    private byte[] passedImage;
    private byte[] failedImage;
    private URLVerifier urlVerifier;
    private SmartCard card = null;
    private byte[] presetPIN = null;
    private Timer timer = new Timer();
    private SmartCardCloser scc = null;
    private CardIDFilter cardIDFilter;

    public CardUpdaterDaemon(CardUpdaterLog logger, CardIDFilter cardIDFilter, URLVerifier urlVerifier) throws IOException {
        this.logger = logger;
        this.cardIDFilter = cardIDFilter;
        this.server = new ServerSocket(27001, 0, InetAddress.getByName(null));
        this.loadImages();
        this.urlVerifier = urlVerifier;
    }

    public void log(int level, String msg) {
        this.logger.log(level, msg);
    }

    @Override
    public void remoteNotify(int id, String message) {
        this.lastMessageId = id;
        this.log(1, message);
    }

    private byte[] loadImage(String name) throws IOException {
        int r;
        InputStream is = CardUpdaterDaemon.class.getResourceAsStream(name);
        byte[] buffer = new byte[1024];
        int ofs = 0;
        int len = buffer.length;
        while ((r = is.read(buffer, ofs, len)) > 0) {
            ofs += r;
            len -= r;
        }
        byte[] rb = new byte[ofs];
        System.arraycopy(buffer, 0, rb, 0, ofs);
        return rb;
    }

    void loadImages() throws IOException {
        this.passedImage = this.loadImage("passed.png");
        this.failedImage = this.loadImage("failed.png");
    }

    void serveResponse(Socket con, boolean passed) throws IOException {
        byte[] image = passed ? this.passedImage : this.failedImage;
        OutputStream os = con.getOutputStream();
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(os));
        out.write("HTTP/1.1 200 OK\r\n");
        out.write("Content-Length: " + image.length + "\r\n");
        out.write("\r\n");
        out.flush();
        os.write(image);
        os.close();
    }

    static String PINStatusString(CHVCardServiceWithControl.PasswordStatus pws) {
        switch (pws) {
            case VERIFIED: {
                return "PIN verified";
            }
            case NOTVERIFIED: {
                return "PIN not verified";
            }
            case BLOCKED: {
                return "PIN is blocked";
            }
            case LASTTRY: {
                return "Last PIN try";
            }
            case NOTINITIALIZED: {
                return "PIN not initialized";
            }
            case RETRYCOUNTERLOW: {
                return "PIn retry counter low";
            }
            case TRANSPORTMODE: {
                return "PIN in transport mode";
            }
        }
        return "Unknown";
    }

    public void setPIN(byte[] pin) {
        this.presetPIN = pin;
    }

    protected void ensurePINVerification(SmartCard sc, int chvNumber) throws CardServiceException, ClassNotFoundException, CardTerminalException {
        CHVCardService chv = (CHVCardService)((Object)sc.getCardService(CHVCardService.class, true));
        boolean verified = true;
        try {
            if (chv instanceof CHVCardServiceWithControl) {
                CHVCardServiceWithControl chvcc = (CHVCardServiceWithControl)chv;
                CHVCardServiceWithControl.PasswordStatus pws = null;
                try {
                    pws = chvcc.getPasswordStatus(null, chvNumber);
                }
                catch (CardServiceUnexpectedStatusWordException e) {
                    this.log(1, "Unexpected SW1/SW2 received from card. Supported card in reader ?");
                    return;
                }
                if (pws == CHVCardServiceWithControl.PasswordStatus.BLOCKED || pws == CHVCardServiceWithControl.PasswordStatus.NOTINITIALIZED) {
                    this.log(1, CardUpdaterDaemon.PINStatusString(pws));
                    return;
                }
                if (pws != CHVCardServiceWithControl.PasswordStatus.VERIFIED) {
                    try {
                        verified = chvcc.verifyPassword(null, chvNumber, this.presetPIN);
                    }
                    catch (CardServiceUnexpectedStatusWordException e) {
                        this.log(1, "PIN verification failed: " + e.getMessage());
                    }
                }
            } else {
                verified = chv.verifyPassword(null, chvNumber, this.presetPIN);
            }
            this.log(1, "PIN verified: " + verified);
        }
        catch (CardServiceInvalidCredentialException | CardServiceOperationFailedException e) {
            this.log(1, "PIN verification cancelled by user");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleRequest() {
        Socket con = null;
        boolean passed = false;
        try {
            block43: {
                String s;
                BufferedReader in;
                String methodAndUrl;
                this.log(1, "Daemon waiting on port 27001...");
                try {
                    con = this.server.accept();
                }
                catch (SocketException se) {
                    boolean bl = false;
                    if (con == null) return bl;
                    try {
                        con.close();
                        return bl;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return bl;
                }
                if (this.scc != null) {
                    this.scc.cancel();
                }
                if ((methodAndUrl = (in = new BufferedReader(new InputStreamReader(con.getInputStream()))).readLine()) == null) {
                    boolean bl = true;
                    return bl;
                }
                this.log(2, methodAndUrl);
                while ((s = in.readLine()) != null && !s.equals("")) {
                    this.log(2, s);
                }
                int sofs = methodAndUrl.indexOf(63);
                if (methodAndUrl.startsWith("GET /") && sofs > 0) {
                    int eofs = methodAndUrl.lastIndexOf(32);
                    String query = methodAndUrl.substring(sofs + 1, eofs);
                    String[] params = query.split("&");
                    String url = null;
                    String sessionId = null;
                    boolean pinRequired = false;
                    int chvNumber = -1;
                    for (String p : params) {
                        String[] keyvalue = p.split("=");
                        if (keyvalue[0].equals("url")) {
                            url = keyvalue[1];
                            continue;
                        }
                        if (keyvalue[0].equals("sessionId")) {
                            sessionId = keyvalue[1];
                            continue;
                        }
                        if (!keyvalue[0].equals("pinrequired")) continue;
                        pinRequired = true;
                        chvNumber = Integer.parseInt(keyvalue[1]);
                    }
                    if (url == null) {
                        this.log(1, "No URL defined in redirect");
                        boolean bl = true;
                        return bl;
                    }
                    boolean valid = this.verifyURL(url);
                    if (!valid) {
                        int n = 1;
                        return n != 0;
                    }
                    try {
                        if (this.card != null && !this.cardIDFilter.isCandidate(this.card.getCardID())) {
                            this.closeCard();
                            this.log(1, "Reader changed");
                        }
                        if (this.card == null) {
                            CardRequest cr = new CardRequest(1, null, RemoteClient.class);
                            cr.setTimeout(0);
                            cr.setFilter(this.cardIDFilter);
                            this.card = SmartCard.waitForCard(cr);
                        }
                        if (this.card == null) {
                            this.log(1, "No card in reader");
                        } else {
                            SmartCard sc = this.card;
                            if (this.logger.getVerbosityLevel() > 1) {
                                sc.setAPDUTracer(new APDUTracerLogAdapter(this.logger));
                            }
                            if (pinRequired) {
                                this.ensurePINVerification(sc, chvNumber);
                            }
                            this.log(1, "Connecting to " + url);
                            RemoteClient rc = (RemoteClient)sc.getCardService(RemoteClient.class, true);
                            rc.update(url, sessionId, this);
                            this.scc = new SmartCardCloser(this);
                            this.timer.schedule((TimerTask)this.scc, 60000L);
                            passed = true;
                        }
                    }
                    catch (Exception e) {
                        this.log(1, e.getMessage());
                        e.printStackTrace();
                        if (this.card == null) break block43;
                        this.card.close();
                        this.card = null;
                    }
                }
            }
            this.serveResponse(con, passed);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return true;
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private boolean verifyURL(String url) {
        if (this.urlVerifier == null) {
            return true;
        }
        this.log(2, "Verify URL " + url);
        try {
            URL urlparts = new URL(url);
            url = urlparts.getProtocol() + "://" + urlparts.getHost();
        }
        catch (MalformedURLException e) {
            return false;
        }
        return this.urlVerifier.verifyURL(url);
    }

    @Override
    public void run() {
        EventGenerator.getGenerator().addCTListener(this);
        while (this.handleRequest()) {
        }
        this.timer.cancel();
    }

    public void stop() {
        if (this.server != null) {
            try {
                this.server.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void cardInserted(CardTerminalEvent ctEvent) throws CardTerminalException {
    }

    public void closeCard() {
        this.card = null;
        this.scc.cancel();
    }

    @Override
    public void cardRemoved(CardTerminalEvent ctEvent) throws CardTerminalException {
        CardTerminal ct;
        if (this.card != null && (ct = this.card.getCardID().getCardTerminal()) != null && ctEvent.getCardTerminal().equals(ct)) {
            this.closeCard();
            this.log(1, "Card removed");
        }
    }

    class SmartCardCloser
    extends TimerTask {
        CardUpdaterDaemon daemon;

        public SmartCardCloser(CardUpdaterDaemon daemon) {
            this.daemon = daemon;
        }

        @Override
        public void run() {
            if (this.daemon.card != null) {
                try {
                    this.daemon.card.close();
                    this.daemon.log(1, "Smartcard closed");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.daemon.card = null;
            }
        }
    }
}

