/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.terminal;

import java.util.Arrays;
import opencard.core.util.HexString;

public abstract class APDU {
    protected byte[] apdu_buffer = null;
    protected int apdu_length = 0;

    public APDU(byte[] buffer, int length) {
        this.apdu_buffer = new byte[length];
        System.arraycopy(buffer, 0, this.apdu_buffer, 0, length);
        this.apdu_length = buffer.length;
    }

    public APDU(byte[] buffer) {
        this(buffer, buffer.length);
    }

    public APDU(int size) {
        this.apdu_buffer = new byte[size];
        this.apdu_length = 0;
    }

    public void append(byte[] bytes) throws IndexOutOfBoundsException {
        System.arraycopy(bytes, 0, this.apdu_buffer, this.apdu_length, bytes.length);
        this.apdu_length += bytes.length;
    }

    public void append(byte b) throws IndexOutOfBoundsException {
        this.apdu_buffer[this.apdu_length++] = b;
    }

    public final byte[] getBuffer() {
        return this.apdu_buffer;
    }

    public final int getByte(int index) {
        if (index >= this.apdu_length) {
            return -1;
        }
        return this.apdu_buffer[index] & 0xFF;
    }

    public final byte[] getBytes() {
        byte[] apdu = new byte[this.apdu_length];
        System.arraycopy(this.apdu_buffer, 0, apdu, 0, this.apdu_length);
        return apdu;
    }

    public final int getLength() {
        return this.apdu_length;
    }

    public final void setByte(int index, int value) {
        if (index < this.apdu_length) {
            this.apdu_buffer[index] = (byte)value;
        }
    }

    public final void setLength(int length) throws IndexOutOfBoundsException {
        if (length > this.apdu_buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        this.apdu_length = length;
    }

    public void clear() {
        Arrays.fill(this.apdu_buffer, (byte)0);
        this.apdu_length = 0;
    }

    protected void finalize() throws Throwable {
        try {
            this.clear();
        }
        finally {
            super.finalize();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("");
        sb.append(super.toString());
        sb.append("\n");
        sb.append(HexString.dump(this.apdu_buffer, 0, this.apdu_length));
        return sb.toString();
    }
}

