/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.terminal.ctapi4ocf;

import de.cardcontact.ctapi.CTAPI;
import de.cardcontact.ctapi.CTAPITerminal;
import de.cardcontact.ctapi.ICTAPIEvent;
import de.cardcontact.opencard.terminal.ctapi4ocf.CTAPICardTerminal;
import de.cardcontact.opencard.terminal.ctapi4ocf.CTAPIWithKeyboardCardTerminal;
import java.util.List;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalFactory;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.Pollable;
import opencard.core.terminal.TerminalInitException;

public class CTAPICardTerminalFactory
implements CardTerminalFactory,
Pollable,
ICTAPIEvent {
    private CTAPI ctapi;

    @Override
    public void open() throws CardTerminalException {
    }

    @Override
    public void close() throws CardTerminalException {
        CardTerminalRegistry.getRegistry().removePollable(this);
    }

    @Override
    public void terminalsAdded(List<CTAPITerminal> terminals) {
        CardTerminalRegistry ctr = CardTerminalRegistry.getRegistry();
        for (CTAPITerminal ctterm : terminals) {
            try {
                ctr.add(new CTAPICardTerminal(ctterm, ""));
            }
            catch (CardTerminalException cardTerminalException) {}
        }
    }

    @Override
    public void terminalsRemoved(List<CTAPITerminal> terminals) {
        CardTerminalRegistry ctr = CardTerminalRegistry.getRegistry();
        for (CTAPITerminal ctterm : terminals) {
            try {
                ctr.remove(ctterm.getName());
            }
            catch (CardTerminalException cardTerminalException) {}
        }
    }

    @Override
    public void poll() throws CardTerminalException {
        this.ctapi.checkEvent();
    }

    public void detectCardTerminals(CardTerminalRegistry ctr, String[] terminfo) throws CardTerminalException, TerminalInitException {
        this.ctapi = new CTAPI(terminfo[3]);
        if (terminfo[1].endsWith("-NOPOLL")) {
            List<CTAPITerminal> terminals = this.ctapi.CT_List();
            for (CTAPITerminal ctterm : terminals) {
                ctr.add(new CTAPICardTerminal(ctterm, terminfo[1]));
            }
        } else {
            this.ctapi.setEventListener(this);
            CardTerminalRegistry.getRegistry().addPollable(this);
        }
    }

    @Override
    public void createCardTerminals(CardTerminalRegistry ctr, String[] terminfo) throws CardTerminalException, TerminalInitException {
        if (terminfo.length != 4) {
            throw new TerminalInitException("CTAPICardTerminalFactory needs 4 parameters.");
        }
        if (terminfo[1].startsWith("AUTO")) {
            this.detectCardTerminals(ctr, terminfo);
        } else if (terminfo[1].startsWith("CTAPIKBD")) {
            ctr.add(new CTAPIWithKeyboardCardTerminal(terminfo[0], terminfo[1], terminfo[2], terminfo[3]));
        } else if (terminfo[1].startsWith("CTAPI")) {
            ctr.add(new CTAPICardTerminal(terminfo[0], terminfo[1], terminfo[2], terminfo[3]));
        } else {
            throw new TerminalInitException("Requested Terminal type not known.");
        }
    }
}

