/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.service.smartcardhsm;

import de.cardcontact.tlv.ConstructedTLV;
import de.cardcontact.tlv.HexString;
import de.cardcontact.tlv.IntegerTLV;
import de.cardcontact.tlv.OctetString;
import de.cardcontact.tlv.PrimitiveTLV;
import de.cardcontact.tlv.Sequence;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import de.cardcontact.tlv.Tag;
import de.cardcontact.tlv.UTF8String;
import java.util.StringTokenizer;

public class KeyDescription {
    private byte[] keyid;
    private String label;
    private int size;
    private KeyTypes type;
    private int keyref = -1;
    private byte[] encoded;
    private Tag TagA0 = new Tag(0, -128, true);
    private Tag TagA1 = new Tag(1, -128, true);
    private Tag ecTag = new Tag(0, -128, true);
    private Tag aesTag = new Tag(8, -128, true);

    public KeyDescription(byte[] keyid, String label, int size, KeyTypes type) {
        this.keyid = keyid;
        this.label = label;
        this.size = size;
        this.type = type;
        switch (type) {
            case RSA: {
                this.makeForRSA();
                break;
            }
            case EC: {
                this.makeForEC();
                break;
            }
            case AES: {
                this.makeForAES();
            }
        }
    }

    public KeyDescription(byte[] prkd) throws TLVEncodingException {
        this.encoded = prkd;
        this.parseEncoded();
    }

    private void makeForEC() {
        ConstructedTLV desc = new ConstructedTLV(this.ecTag).add(new Sequence().add(new UTF8String(this.label))).add(new Sequence().add(new OctetString(this.keyid)).add(new PrimitiveTLV(Tag.TAG_BIT_STRING, new byte[]{7, 32, -128}))).add(new ConstructedTLV(new Tag(1, -128, true)).add(new Sequence().add(new Sequence().add(new OctetString(new byte[0]))).add(new IntegerTLV(this.size))));
        this.encoded = desc.getBytes();
    }

    private void makeForRSA() {
        ConstructedTLV desc = new Sequence().add(new Sequence().add(new UTF8String(this.label))).add(new Sequence().add(new OctetString(this.keyid)).add(new PrimitiveTLV(Tag.TAG_BIT_STRING, new byte[]{2, 116}))).add(new ConstructedTLV(new Tag(1, -128, true)).add(new Sequence().add(new Sequence().add(new OctetString(new byte[0]))).add(new IntegerTLV(this.size))));
        this.encoded = desc.getBytes();
    }

    private void makeForAES() {
        ConstructedTLV desc = new ConstructedTLV(this.aesTag).add(new Sequence().add(new UTF8String(this.label))).add(new Sequence().add(new OctetString(this.keyid)).add(new PrimitiveTLV(Tag.TAG_BIT_STRING, new byte[]{7, -64, 16}))).add(new ConstructedTLV(new Tag(0, -128, true)).add(new Sequence().add(new IntegerTLV(this.size)))).add(new ConstructedTLV(new Tag(1, -128, true)).add(new Sequence().add(new Sequence().add(new OctetString(new byte[0])))));
        this.encoded = desc.getBytes();
    }

    private void parseEncoded() throws TLVEncodingException {
        ConstructedTLV tlv = (ConstructedTLV)TLV.factory(this.encoded);
        Sequence seq = Sequence.getInstance(tlv.get(0));
        this.label = UTF8String.getInstance(seq.get(0)).toString();
        seq = Sequence.getInstance(tlv.get(1));
        this.keyid = OctetString.getInstance(seq.get(0)).getValue();
        int i = 2;
        if (tlv.getTag().equals(Tag.TAG_SEQUENCE)) {
            this.type = KeyTypes.RSA;
            if (tlv.get(i).getTag().equals(this.TagA0)) {
                ++i;
            }
            seq = Sequence.getInstance(tlv.get(i), this.TagA1);
            seq = Sequence.getInstance(seq.get(0));
            this.size = (int)IntegerTLV.getInstance(seq.get(1)).getLong();
        } else if (tlv.getTag().equals(this.ecTag)) {
            this.type = KeyTypes.EC;
            if (tlv.get(i).getTag().equals(this.TagA0)) {
                ++i;
            }
            seq = Sequence.getInstance(tlv.get(i), this.TagA1);
            this.size = (seq = Sequence.getInstance(seq.get(0))).getElements() > 1 ? (int)IntegerTLV.getInstance(seq.get(1)).getLong() : 0;
        } else if (tlv.getTag().equals(this.aesTag)) {
            this.type = KeyTypes.AES;
            seq = Sequence.getInstance(tlv.get(2), this.TagA0);
            if (seq.get(0).getTag().equals(Tag.TAG_SEQUENCE)) {
                seq = Sequence.getInstance(seq.get(0));
            }
            this.size = (int)IntegerTLV.getInstance(seq.get(0)).getLong();
            if (this.size < 0) {
                this.size = -this.size;
            }
        } else {
            throw new TLVEncodingException("Unknown key description format");
        }
    }

    public byte[] getKeyID() {
        return this.keyid;
    }

    public String getLabel() {
        return this.label;
    }

    public void setKeyRef(byte ref) {
        this.keyref = ref & 0xFF;
    }

    public String getTranslatedLabel() {
        StringBuffer str = new StringBuffer();
        String label = this.getLabel();
        StringTokenizer tokenizer = new StringTokenizer(label, "%");
        if (tokenizer.hasMoreElements() && label.charAt(0) != '%') {
            str.append(tokenizer.nextToken());
        }
        block10: while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken();
            switch (token.charAt(0)) {
                case 'i': {
                    if (this.keyid != null) {
                        str.append(HexString.hexifyByteArray(this.keyid));
                    }
                    str.append(token.substring(1));
                    continue block10;
                }
                case 'r': {
                    if (this.keyref != -1) {
                        str.append(this.keyref);
                    }
                    str.append(token.substring(1));
                    continue block10;
                }
                case 't': {
                    switch (this.type) {
                        case RSA: {
                            str.append("RSA");
                            break;
                        }
                        case EC: {
                            str.append("EC");
                            break;
                        }
                        case AES: {
                            str.append("AES");
                        }
                    }
                    str.append(token.substring(1));
                    continue block10;
                }
            }
            str.append(token);
        }
        return str.toString();
    }

    public int getSize() {
        return this.size;
    }

    public KeyTypes getType() {
        return this.type;
    }

    public byte[] getEncoded() {
        return this.encoded;
    }

    public static enum KeyTypes {
        RSA,
        EC,
        AES;

    }
}

