/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;

public class ClientProperties {
    private Properties properties = new Properties();
    public static final String USER_HOME = System.getProperty("user.home");
    public static final String DIR = "CardContact";
    public static final String FILE_NAME = "ocfclient.properties";
    private static final String KEY_READER = "reader";
    private static final String KEY_IGNORE = "ignore";
    private static final String KEY_SERVER_URL = "url";
    private static final String DELIMITER = " ; ";

    public ClientProperties() {
        try {
            File file = this.getFile();
            FileInputStream fi = new FileInputStream(file);
            this.properties.load(fi);
            fi.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private File getFile() {
        File propertiesDir = new File(USER_HOME + "/" + DIR);
        File propertiesFile = new File(USER_HOME + "/" + DIR + "/" + FILE_NAME);
        if (!propertiesDir.exists() | !propertiesDir.isDirectory()) {
            boolean bl = propertiesDir.mkdir();
        }
        if (!propertiesFile.exists()) {
            try {
                propertiesFile.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return propertiesFile;
    }

    private void save(String key, String value) {
        this.properties.setProperty(key, value);
        File file = this.getFile();
        try {
            file.createNewFile();
            FileOutputStream fo = new FileOutputStream(file);
            this.properties.store(fo, "OCF Client configuration file");
            fo.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void saveReaderName(String reader) {
        this.save(KEY_READER, reader);
    }

    public String getReaderName() {
        String reader = this.properties.getProperty(KEY_READER);
        if (reader == null) {
            reader = "";
        }
        return reader;
    }

    public void appendToIgnored(HashSet<String> reader) {
        HashSet<String> ignored = this.getIgnoredReader();
        String ignoreList = "";
        for (String r : reader) {
            if (ignored.contains(r)) continue;
            ignoreList = ignoreList + r + DELIMITER;
        }
        String propertyList = this.properties.getProperty(KEY_IGNORE);
        if (propertyList == null) {
            propertyList = "";
        }
        propertyList = propertyList + ignoreList;
        this.save(KEY_IGNORE, propertyList);
    }

    public HashSet<String> getIgnoredReader() {
        String[] ignored;
        HashSet<String> readerSet = new HashSet<String>();
        String readerList = this.properties.getProperty(KEY_IGNORE);
        if (readerList == null) {
            return readerSet;
        }
        for (String reader : ignored = readerList.split(DELIMITER)) {
            if (reader.equals("")) continue;
            readerSet.add(reader);
        }
        return readerSet;
    }

    public void saveIgnoredReader(HashSet<String> ignored) {
        String ignoreList = "";
        for (String r : ignored) {
            ignoreList = ignoreList + r + DELIMITER;
        }
        this.save(KEY_IGNORE, ignoreList);
    }

    public void saveServerURL(HashSet<String> urlSet) {
        String urlList = "";
        for (String url : urlSet) {
            urlList = urlList + url + DELIMITER;
        }
        this.save(KEY_SERVER_URL, urlList);
    }

    public void appendServerURL(String newUrl) {
        HashSet<String> urlSet = this.getServerURL();
        if (urlSet.contains(newUrl)) {
            return;
        }
        String list = "";
        for (String url : urlSet) {
            list = list + url + DELIMITER;
        }
        list = list + newUrl + DELIMITER;
        this.save(KEY_SERVER_URL, list);
    }

    public HashSet<String> getServerURL() {
        String[] approved;
        HashSet<String> urlSet = new HashSet<String>();
        String urlList = this.properties.getProperty(KEY_SERVER_URL);
        if (urlList == null) {
            return urlSet;
        }
        for (String url : approved = urlList.split(DELIMITER)) {
            if (url.equals("")) continue;
            urlSet.add(url);
        }
        return urlSet;
    }
}

