/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.service;

import opencard.core.service.CHVDialog;
import opencard.core.service.CardChannel;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.CardType;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CardService {
    private static final Logger logger = LoggerFactory.getLogger(CardService.class);
    private SmartCard smart_card = null;
    private CardServiceScheduler cs_scheduler = null;
    private CardChannel card_channel = null;
    private CardType type = null;
    private boolean is_provided = false;
    private boolean is_blocking = false;
    private CHVDialog chv_dialog = null;

    protected CardService() {
        logger.debug("[init] default constructor of " + this);
    }

    public void setCardChannel(CardChannel channel) {
        this.card_channel = channel;
        this.is_provided = channel != null;
    }

    public final CardChannel getCardChannel() {
        return this.card_channel;
    }

    public void setCHVDialog(CHVDialog dialog) {
        this.chv_dialog = dialog;
    }

    public final CHVDialog getCHVDialog() {
        return this.chv_dialog;
    }

    public final SmartCard getCard() {
        return this.smart_card;
    }

    protected void initialize(CardServiceScheduler scheduler, SmartCard smartcard, boolean blocking) throws CardServiceException {
        logger.debug("[initialize] (" + scheduler + "," + smartcard + ")");
        this.smart_card = smartcard;
        this.cs_scheduler = scheduler;
        this.is_blocking = blocking;
    }

    protected void allocateCardChannel() throws InvalidCardChannelException {
        this.assertSchedulerStillAlive();
        if (!this.is_provided) {
            logger.debug("[allocateCardChannel] allocating");
            try {
                this.card_channel = this.cs_scheduler.allocateCardChannel(this, this.is_blocking);
                if (this.card_channel == null) {
                    throw new InvalidCardChannelException("channel in use");
                }
            }
            catch (CardTerminalException ctx) {
                throw new InvalidCardChannelException(ctx.toString());
            }
        }
    }

    protected void releaseCardChannel() throws InvalidCardChannelException {
        this.assertSchedulerStillAlive();
        if (!this.is_provided) {
            logger.debug("[releaseCardChannel] releasing");
            this.cs_scheduler.releaseCardChannel(this.card_channel);
        }
    }

    private void assertSchedulerStillAlive() throws InvalidCardChannelException {
        boolean alive = false;
        try {
            alive = this.cs_scheduler != null && this.cs_scheduler.isAlive();
        }
        catch (CardTerminalException ctx) {
            throw new InvalidCardChannelException(ctx.toString());
        }
        if (!alive) {
            this.card_channel = null;
            this.cs_scheduler = null;
            throw new InvalidCardChannelException("card removed?");
        }
    }
}

