/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.cli;

import de.cardcontact.cli.CardUpdaterLog;
import de.cardcontact.cli.TerminalManager;
import de.cardcontact.cli.URLVerifier;
import de.cardcontact.opencard.service.CardServiceUnexpectedStatusWordException;
import de.cardcontact.opencard.service.isocard.CHVCardServiceWithControl;
import de.cardcontact.opencard.service.remoteclient.RemoteClient;
import de.cardcontact.opencard.service.remoteclient.RemoteNotificationListener;
import de.cardcontact.opencard.utils.StreamingAPDUTracer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import java.util.Timer;
import java.util.TimerTask;
import opencard.core.event.CTListener;
import opencard.core.event.CardTerminalEvent;
import opencard.core.event.EventGenerator;
import opencard.core.service.CardRequest;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceInvalidCredentialException;
import opencard.core.service.CardServiceOperationFailedException;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.opt.security.CHVCardService;

public class CardUpdaterDaemon
implements Runnable,
CTListener,
RemoteNotificationListener,
Observer {
    static final int SERVER_PORT = 27001;
    static final int closingDelay = 60;
    private CardUpdaterLog logger;
    private int lastMessageId = 0;
    private ServerSocket server;
    private byte[] passedImage;
    private byte[] failedImage;
    private URLVerifier urlVerifier;
    private SmartCard card = null;
    private byte[] presetPIN = null;
    private Timer timer = new Timer();
    private SmartCardCloser scc = null;
    private boolean terminalChanged = false;
    private TerminalManager terminalManager;

    public CardUpdaterDaemon(CardUpdaterLog logger, TerminalManager tm) throws IOException {
        this.logger = logger;
        this.terminalManager = tm;
        this.terminalManager.addObserver(this);
        this.server = new ServerSocket(27001, 0, InetAddress.getByName(null));
        this.loadImages();
        this.urlVerifier = new URLVerifier();
    }

    public void log(int level, String msg) {
        this.logger.log(level, msg);
    }

    @Override
    public void remoteNotify(int id, String message) {
        this.lastMessageId = id;
        this.log(1, message);
    }

    private byte[] loadImage(String name) throws IOException {
        int r;
        InputStream is = CardUpdaterDaemon.class.getResourceAsStream(name);
        byte[] buffer = new byte[1024];
        int ofs = 0;
        int len = buffer.length;
        while ((r = is.read(buffer, ofs, len)) > 0) {
            ofs += r;
            len -= r;
        }
        byte[] rb = new byte[ofs];
        System.arraycopy(buffer, 0, rb, 0, ofs);
        return rb;
    }

    void loadImages() throws IOException {
        this.passedImage = this.loadImage("passed.png");
        this.failedImage = this.loadImage("failed.png");
    }

    void serveResponse(Socket con, boolean passed) throws IOException {
        byte[] image = passed ? this.passedImage : this.failedImage;
        OutputStream os = con.getOutputStream();
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(os));
        out.write("HTTP/1.1 200 OK\r\n");
        out.write("Content-Length: " + image.length + "\r\n");
        out.write("\r\n");
        out.flush();
        os.write(image);
        os.close();
    }

    static String PINStatusString(CHVCardServiceWithControl.PasswordStatus pws) {
        switch (pws) {
            case VERIFIED: {
                return "PIN verified";
            }
            case NOTVERIFIED: {
                return "PIN not verified";
            }
            case BLOCKED: {
                return "PIN is blocked";
            }
            case LASTTRY: {
                return "Last PIN try";
            }
            case NOTINITIALIZED: {
                return "PIN not initialized";
            }
            case RETRYCOUNTERLOW: {
                return "PIn retry counter low";
            }
            case TRANSPORTMODE: {
                return "PIN in transport mode";
            }
        }
        return "Unknown";
    }

    public void setPIN(byte[] pin) {
        this.presetPIN = pin;
    }

    private void ensurePINVerification(SmartCard sc, int chvNumber) throws CardServiceException, ClassNotFoundException, CardTerminalException {
        CHVCardService chv = (CHVCardService)((Object)sc.getCardService(CHVCardService.class, true));
        boolean verified = true;
        try {
            if (chv instanceof CHVCardServiceWithControl) {
                CHVCardServiceWithControl chvcc = (CHVCardServiceWithControl)chv;
                CHVCardServiceWithControl.PasswordStatus pws = null;
                try {
                    pws = chvcc.getPasswordStatus(null, chvNumber);
                }
                catch (CardServiceUnexpectedStatusWordException e) {
                    this.log(1, "Unexpected SW1/SW2 received from card. Supported card in reader ?");
                    return;
                }
                if (pws == CHVCardServiceWithControl.PasswordStatus.BLOCKED || pws == CHVCardServiceWithControl.PasswordStatus.NOTINITIALIZED) {
                    this.log(1, CardUpdaterDaemon.PINStatusString(pws));
                    return;
                }
                if (pws != CHVCardServiceWithControl.PasswordStatus.VERIFIED) {
                    try {
                        verified = chvcc.verifyPassword(null, chvNumber, this.presetPIN);
                    }
                    catch (CardServiceUnexpectedStatusWordException e) {
                        this.log(1, "PIN verification failed: " + e.getMessage());
                    }
                }
            } else {
                verified = chv.verifyPassword(null, chvNumber, this.presetPIN);
            }
            this.log(1, "PIN verified: " + verified);
        }
        catch (CardServiceInvalidCredentialException | CardServiceOperationFailedException e) {
            this.log(1, "PIN verification cancelled by user");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleRequest() {
        Socket con = null;
        boolean passed = false;
        try {
            block37: {
                String s;
                BufferedReader in;
                String methodAndUrl;
                this.log(1, "Daemon waiting on port 27001...");
                con = this.server.accept();
                if (this.scc != null) {
                    this.scc.cancel();
                }
                if ((methodAndUrl = (in = new BufferedReader(new InputStreamReader(con.getInputStream()))).readLine()) == null) {
                    return;
                }
                this.log(2, methodAndUrl);
                while ((s = in.readLine()) != null && !s.equals("")) {
                    this.log(2, s);
                }
                int sofs = methodAndUrl.indexOf(63);
                if (methodAndUrl.startsWith("GET /") && sofs > 0) {
                    int eofs = methodAndUrl.lastIndexOf(32);
                    String query = methodAndUrl.substring(sofs + 1, eofs);
                    String[] params = query.split("&");
                    String url = null;
                    String sessionId = null;
                    boolean pinRequired = false;
                    int chvNumber = -1;
                    for (String p : params) {
                        String[] keyvalue = p.split("=");
                        if (keyvalue[0].equals("url")) {
                            url = keyvalue[1];
                            continue;
                        }
                        if (keyvalue[0].equals("sessionId")) {
                            sessionId = keyvalue[1];
                            continue;
                        }
                        if (!keyvalue[0].equals("pinrequired")) continue;
                        pinRequired = true;
                        chvNumber = Integer.parseInt(keyvalue[1]);
                    }
                    if (url == null) {
                        this.log(1, "No URL defined in redirect");
                        return;
                    }
                    boolean valid = this.verifyURL(url);
                    if (!valid) {
                        return;
                    }
                    try {
                        if (this.card == null || this.terminalChanged) {
                            CardTerminalRegistry ctr = CardTerminalRegistry.getRegistry();
                            CardTerminal ct = ctr.cardTerminalForName(this.terminalManager.getSelectedTerminal());
                            CardRequest cr = new CardRequest(1, ct, RemoteClient.class);
                            cr.setTimeout(0);
                            cr.setFilter(this.terminalManager);
                            this.card = SmartCard.waitForCard(cr);
                            this.terminalChanged = false;
                        }
                        if (this.card == null) {
                            this.log(1, "No card in reader");
                        } else {
                            SmartCard sc = this.card;
                            if (this.logger.getVerbosityLevel() > 1) {
                                sc.setAPDUTracer(new StreamingAPDUTracer(System.out));
                            }
                            if (pinRequired) {
                                this.ensurePINVerification(sc, chvNumber);
                            }
                            this.log(1, "Connecting to " + url);
                            RemoteClient rc = (RemoteClient)sc.getCardService(RemoteClient.class, true);
                            rc.update(url, sessionId, this);
                            this.scc = new SmartCardCloser(this);
                            this.timer.schedule((TimerTask)this.scc, 60000L);
                            passed = true;
                        }
                    }
                    catch (Exception e) {
                        this.log(1, e.getMessage());
                        e.printStackTrace();
                        if (this.card == null) break block37;
                        this.card.close();
                        this.card = null;
                    }
                }
            }
            this.serveResponse(con, passed);
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private boolean verifyURL(String url) {
        if (this.urlVerifier == null) {
            return true;
        }
        this.log(2, "Verify URL " + url);
        try {
            URL urlparts = new URL(url);
            url = urlparts.getProtocol() + "://" + urlparts.getHost();
        }
        catch (MalformedURLException e) {
            return false;
        }
        return this.urlVerifier.verifyURL(url);
    }

    @Override
    public void run() {
        EventGenerator.getGenerator().addCTListener(this);
        while (true) {
            this.handleRequest();
        }
    }

    @Override
    public void cardInserted(CardTerminalEvent ctEvent) throws CardTerminalException {
    }

    @Override
    public void cardRemoved(CardTerminalEvent ctEvent) throws CardTerminalException {
        CardTerminal ct;
        if (this.card != null && (ct = this.card.getCardID().getCardTerminal()) != null && ctEvent.getCardTerminal().equals(ct)) {
            this.card = null;
            this.scc.cancel();
            this.log(1, "Card removed");
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        this.terminalChanged = true;
    }

    class SmartCardCloser
    extends TimerTask {
        CardUpdaterDaemon daemon;

        public SmartCardCloser(CardUpdaterDaemon daemon) {
            this.daemon = daemon;
        }

        @Override
        public void run() {
            if (this.daemon.card != null) {
                try {
                    this.daemon.card.close();
                    this.daemon.log(1, "Smartcard closed");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.daemon.card = null;
            }
        }
    }
}

