/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.terminal;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import opencard.core.event.CTListener;
import opencard.core.event.EventGenerator;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.Observer;
import opencard.core.terminal.Pollable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CardTerminalRegistry {
    private Observer observer = null;
    protected Hashtable ctListeners = new Hashtable();
    private static final Logger logger = LoggerFactory.getLogger(CardTerminalRegistry.class);
    private static final CardTerminalRegistry registry = new CardTerminalRegistry();
    private Vector registeredTerminals = new Vector();

    public void setObserver(Observer o) {
        this.observer = o;
    }

    private CardTerminalRegistry() {
    }

    public static synchronized CardTerminalRegistry getRegistry() {
        return registry;
    }

    public void add(CardTerminal terminal) throws CardTerminalException {
        this.registeredTerminals.addElement(terminal);
        terminal.open();
    }

    public void addPollable(Pollable p) {
        if (this.observer != null) {
            this.observer.updateTerminals(p, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CardTerminal cardTerminalForName(String name) {
        CardTerminal terminal = null;
        Vector vector = this.registeredTerminals;
        synchronized (vector) {
            for (int i = 0; i < this.countCardTerminals(); ++i) {
                if (!((CardTerminal)this.registeredTerminals.elementAt(i)).getName().equals(name)) continue;
                terminal = (CardTerminal)this.registeredTerminals.elementAt(i);
                break;
            }
        }
        return terminal;
    }

    public int countCardTerminals() {
        return this.registeredTerminals.size();
    }

    public Enumeration getCardTerminals() {
        return ((Vector)this.registeredTerminals.clone()).elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String name) throws CardTerminalException {
        CardTerminal ct = null;
        Vector vector = this.registeredTerminals;
        synchronized (vector) {
            for (int i = 0; i < this.registeredTerminals.size(); ++i) {
                ct = (CardTerminal)this.registeredTerminals.elementAt(i);
                if (!ct.getName().equals(name)) continue;
                ct.close();
                this.registeredTerminals.removeElementAt(i);
                break;
            }
        }
        return false;
    }

    public boolean remove(CardTerminal terminal) throws CardTerminalException {
        logger.debug("[remove] closing " + terminal);
        terminal.close();
        logger.debug("[remove] removing " + terminal);
        boolean taskAccomplished = this.registeredTerminals.removeElement(terminal);
        logger.debug("[remove] status " + taskAccomplished);
        return taskAccomplished;
    }

    public boolean removePollable(Pollable p) {
        if (this.observer != null) {
            return this.observer.updateTerminals(p, false);
        }
        return false;
    }

    protected void cardInserted(CardTerminal terminal, int slotID) {
        if (this.observer != null) {
            this.observer.updateCards(terminal, slotID, true);
        }
    }

    protected void cardRemoved(CardTerminal terminal, int slotID) {
        if (this.observer != null) {
            this.observer.updateCards(terminal, slotID, false);
        }
    }

    @Deprecated
    public void setPollInterval(int duration) {
        EventGenerator.getGenerator().setPollInterval(duration);
    }

    @Deprecated
    public void addCTListener(CTListener listener) {
        EventGenerator.getGenerator().addCTListener(listener);
    }

    @Deprecated
    public void createEventsForPresentCards(CTListener ctListener) throws CardTerminalException {
        EventGenerator.getGenerator().createEventsForPresentCards(ctListener);
    }

    @Deprecated
    public int getPollInterval() {
        return EventGenerator.getGenerator().getPollInterval();
    }

    @Deprecated
    public void removeCTListener(CTListener listener) {
        EventGenerator.getGenerator().removeCTListener(listener);
    }
}

