/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.tlv;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

public class ObjectIdentifierRegistry {
    private static ObjectIdentifierRegistry instance = null;
    private HashMap<String, String> nameMap = new HashMap();
    private HashMap<ByteStringWrapper, String> oidMap = new HashMap();

    private ObjectIdentifierRegistry() {
    }

    public static ObjectIdentifierRegistry getInstance() {
        if (instance == null) {
            instance = new ObjectIdentifierRegistry();
        }
        return instance;
    }

    protected static byte[] encodeOID(List<Integer> oid) {
        int val;
        int i;
        if (oid.size() < 2 || oid.get(0) < 0 || oid.get(0) > 2 || oid.get(1) < 0 || oid.get(1) > 39) {
            throw new IllegalArgumentException("Object identifier out of range");
        }
        int size = 1;
        for (i = 2; i < oid.size(); ++i) {
            val = oid.get(i);
            if (val < 0) {
                throw new IllegalArgumentException("Object identifier out of range");
            }
            do {
                ++size;
            } while ((val >>= 7) > 0);
        }
        byte[] value = new byte[size];
        value[0] = (byte)(40 * oid.get(0) + oid.get(1));
        int j = 1;
        for (i = 2; i < oid.size(); ++i) {
            val = oid.get(i);
            size = -7;
            do {
                size += 7;
            } while ((val >>= 7) > 0);
            val = oid.get(i);
            while (size >= 0) {
                value[j++] = (byte)(val >> size & 0x7F | 0x80);
                size -= 7;
            }
            int n = j - 1;
            value[n] = (byte)(value[n] & 0x7F);
        }
        return value;
    }

    private static ArrayList<Integer> parseObjectIdentifierString(String oid, int recursioncount) {
        if (recursioncount < 0) {
            throw new IllegalArgumentException("Recursive definition of " + oid);
        }
        StringTokenizer sp = new StringTokenizer(oid, " .");
        ArrayList<Integer> elements = new ArrayList<Integer>(sp.countTokens());
        while (sp.hasMoreTokens()) {
            Integer i;
            String temp = sp.nextToken();
            try {
                i = new Integer(temp);
                elements.add(i);
            }
            catch (NumberFormatException nfe) {
                if (temp.matches("^[\\w-]+\\(\\d+\\)$")) {
                    String nstr = temp.substring(temp.indexOf(40) + 1, temp.indexOf(41));
                    i = new Integer(nstr);
                    elements.add(i);
                    continue;
                }
                String str = instance.getOIDFor(temp);
                if (str == null) {
                    throw new IllegalArgumentException("'" + temp + "' is an unknown identifier");
                }
                elements.addAll(ObjectIdentifierRegistry.parseObjectIdentifierString(str, recursioncount - 1));
            }
        }
        return elements;
    }

    public static byte[] parseObjectIdentifier(String oid) {
        ArrayList<Integer> elements = ObjectIdentifierRegistry.parseObjectIdentifierString(oid, 100);
        return ObjectIdentifierRegistry.encodeOID(elements);
    }

    public void addIdentifier(String name, String oid) {
        String c = this.nameMap.get(name);
        if (c != null && !c.equals(oid)) {
            throw new IllegalArgumentException("'" + name + "' already defined as " + c);
        }
        byte[] encoded = ObjectIdentifierRegistry.parseObjectIdentifier(oid);
        ByteStringWrapper bsw = new ByteStringWrapper(encoded);
        c = this.oidMap.get(bsw);
        if (c != null && !c.equals(name)) {
            throw new IllegalArgumentException("'" + name + "' already defined by " + c);
        }
        this.nameMap.put(name, oid);
        this.oidMap.put(new ByteStringWrapper(encoded), name);
    }

    public String getOIDFor(String name) {
        return this.nameMap.get(name);
    }

    public String getNameFor(byte[] oid) {
        return this.oidMap.get(new ByteStringWrapper(oid));
    }

    private class ByteStringWrapper {
        private final byte[] bs;

        public ByteStringWrapper(byte[] bs) {
            this.bs = bs;
        }

        public int hashCode() {
            return Arrays.hashCode(this.bs);
        }

        public boolean equals(Object o) {
            if (!(o instanceof ByteStringWrapper)) {
                return false;
            }
            return Arrays.equals(this.bs, ((ByteStringWrapper)o).bs);
        }
    }
}

