/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.utils;

import de.cardcontact.opencard.service.InstructionCodeTable;
import de.cardcontact.opencard.service.StatusWordTable;
import de.cardcontact.tlv.HexString;
import java.io.PrintStream;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.SlotChannel;
import opencard.core.util.APDUTracer;

public class StreamingAPDUTracer
implements APDUTracer {
    PrintStream stream = null;

    public StreamingAPDUTracer(PrintStream stream) {
        this.stream = stream;
    }

    public static String commandAPDUToString(CommandAPDU capdu) {
        StringBuffer sb = new StringBuffer(80);
        try {
            boolean extended = false;
            int len = capdu.getLength();
            byte[] buf = capdu.getBuffer();
            sb.append("C: ");
            sb.append(HexString.hexifyByteArray(buf, ' ', 4));
            sb.append(" - ");
            sb.append(InstructionCodeTable.instructionNameFromHeader(capdu.getBuffer()));
            int bodyoffset = 4;
            if ((len -= 4) > 0) {
                int n = -1;
                if (buf[bodyoffset] == 0 && len > 1) {
                    if (len >= 3) {
                        n = ((buf[bodyoffset + 1] & 0xFF) << 8) + (buf[bodyoffset + 2] & 0xFF);
                        bodyoffset += 3;
                        len -= 3;
                        extended = true;
                    } else {
                        sb.append("Invalid extended length encoding for Lc\n");
                        sb.append(HexString.dump(buf, bodyoffset, len, 16, 6));
                    }
                } else {
                    n = buf[bodyoffset] & 0xFF;
                    ++bodyoffset;
                    --len;
                }
                if (len > 0) {
                    sb.append(" Lc=" + n + " " + (extended ? "Extended" : "") + "\n");
                    if (n > len) {
                        n = len;
                    }
                    sb.append(HexString.dump(buf, bodyoffset, n, 16, 6));
                    bodyoffset += n;
                    len -= n;
                    n = -1;
                    if (len > 0) {
                        if (extended) {
                            if (len >= 2) {
                                n = ((buf[bodyoffset] & 0xFF) << 8) + (buf[bodyoffset + 1] & 0xFF);
                                bodyoffset += 2;
                                len -= 2;
                            } else {
                                sb.append("Invalid extended length encoding for Le\n");
                                sb.append(HexString.dump(buf, bodyoffset, len, 16, 6));
                            }
                        } else {
                            n = buf[bodyoffset] & 0xFF;
                            ++bodyoffset;
                            --len;
                        }
                    }
                }
                if (n >= 0) {
                    sb.append("      Le=" + n + " " + (extended ? "Extended" : "") + "\n");
                }
                if (len > 0) {
                    sb.append("Unexpected bytes:\n");
                    sb.append(HexString.dump(buf, bodyoffset, len, 16, 6));
                }
            } else {
                sb.append("\n");
            }
        }
        catch (Exception e) {
            return "Error decoding APDU";
        }
        return sb.toString();
    }

    @Override
    public void traceCommandAPDU(SlotChannel sc, CommandAPDU capdu) {
        int slotId = sc.getCardTerminal().getName().hashCode() + sc.getSlotNumber() & 0xFF;
        String s = HexString.hexifyByte(slotId);
        s = s.concat(" ");
        s = s.concat(StreamingAPDUTracer.commandAPDUToString(capdu));
        this.stream.print(s);
    }

    @Override
    public void traceResponseAPDU(SlotChannel sc, ResponseAPDU rapdu) {
        try {
            StringBuffer sb = new StringBuffer(80);
            int len = rapdu.getLength();
            byte[] buf = rapdu.getBuffer();
            sb.append("   R: ");
            sb.append(StatusWordTable.MessageForSW(rapdu.sw()));
            sb.append(" Lr=" + (len - 2));
            sb.append("\n");
            if (len > 2) {
                sb.append(HexString.dump(buf, 0, len - 2, 16, 6));
            }
            this.stream.print(sb.toString());
        }
        catch (Exception e) {
            this.stream.println("Error decoding APDU:");
            e.printStackTrace(this.stream);
        }
    }

    @Override
    public void traceAnswerToReset(SlotChannel sc, CardID cardID) {
        this.stream.println(" ATR: " + HexString.hexifyByteArray(cardID.getATR()));
    }
}

