/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.terminal.ctapi4ocf;

import de.cardcontact.ctapi.CTAPI;
import de.cardcontact.ctapi.CTAPITerminal;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.Pollable;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import opencard.opt.terminal.TerminalCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CTAPICardTerminal
extends CardTerminal
implements Pollable,
TerminalCommand {
    private static final Logger clogger = LoggerFactory.getLogger((String)(CTAPICardTerminal.class.getName() + " Class"));
    private static final byte NOCARD = 0;
    private static final byte CARDIN = 1;
    private static final byte CARDDISCONNECTED = 3;
    private static final byte CARDCONNECTED = 5;
    public static final byte[] requestICC = new byte[]{32, 18, 1, 1, 0};
    public static final byte[] getStatus = new byte[]{32, 19, 0, -128, 0};
    protected boolean termopened;
    protected byte[] cardStatus;
    protected CardID[] cardIdTable;
    protected CTAPI CT;
    protected char ctn;
    protected char pn;
    private boolean polling;
    private boolean processingAPDU = false;

    protected CTAPICardTerminal(String name, String type, String device, String libname) throws CardTerminalException {
        super(name, type, device);
        this.polling = !type.endsWith("-NOPOLL");
        this.termopened = false;
        this.CT = new CTAPI(libname);
        try {
            this.ctn = (char)Integer.decode(this.address).intValue();
        }
        catch (NumberFormatException nfe) {
            throw new CardTerminalException("CTAPICardTerminal: Invalid port address.");
        }
        this.pn = this.ctn;
    }

    protected CTAPICardTerminal(CTAPITerminal ctterm, String type) throws CardTerminalException {
        super(ctterm.getName(), type, "");
        this.polling = !type.endsWith("-NOPOLL");
        this.termopened = false;
        this.CT = ctterm.getCTAPI();
        this.ctn = this.pn = (char)ctterm.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws CardTerminalException {
        int rc;
        if (this.termopened) {
            throw new CardTerminalException("CTAPICardTerminal: Already opened.");
        }
        CTAPICardTerminal cTAPICardTerminal = this;
        synchronized (cTAPICardTerminal) {
            rc = this.CT.CT_Init(this.ctn, this.pn);
        }
        if (rc < 0) {
            throw new CardTerminalException("CTAPICardTerminal: CT_Init failed with rc=" + rc);
        }
        this.termopened = true;
        byte[] newStatus = this.getStatus();
        int len = newStatus.length;
        this.addSlots(len);
        this.cardStatus = new byte[len];
        this.cardIdTable = new CardID[len];
        if (this.polling) {
            CardTerminalRegistry.getRegistry().addPollable(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws CardTerminalException {
        if (!this.termopened) {
            throw new CardTerminalException("CTAPICardTerminal: Terminal not opened.");
        }
        this.cardRemoved(0);
        if (this.polling) {
            CardTerminalRegistry.getRegistry().removePollable(this);
        }
        CTAPICardTerminal cTAPICardTerminal = this;
        synchronized (cTAPICardTerminal) {
            int rc = this.CT.CT_Close(this.ctn);
            if (rc == 0 || rc == -8) {
                this.termopened = false;
            }
        }
        if (this.termopened) {
            CardTerminalRegistry.getRegistry().addPollable(this);
            throw new CardTerminalException("CTAPICardTerminal: CT_close failed.");
        }
    }

    @Override
    public boolean isCardPresent(int slot) throws CardTerminalException {
        if (!this.termopened) {
            throw new CardTerminalException("CTAPICardTerminal: isCardPresent(), Terminal not opened.");
        }
        if (!this.polling) {
            this.poll();
        }
        return this.cardIdTable[slot] != null;
    }

    @Override
    public CardID getCardID(int slot) throws CardTerminalException {
        if (!this.termopened) {
            throw new CardTerminalException("CTAPICardTerminal: getCardID(), Terminal not opened.");
        }
        return this.cardIdTable[slot];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CardID internalReset(int slot, int ms) throws CardTerminalException {
        CardID cid;
        int res;
        byte[] buf = new byte[258];
        byte[] com = new byte[]{32, 17, (byte)(slot + 1), 1, 0};
        if (!this.termopened) {
            throw new CardTerminalException("CTAPICardTerminal: internalReset(), Terminal not opened.");
        }
        this.cardIdTable[slot] = null;
        char buflen = (char)buf.length;
        CTAPICardTerminal cTAPICardTerminal = this;
        synchronized (cTAPICardTerminal) {
            res = this.CT.CT_Data(this.ctn, (byte)1, (byte)2, com, buflen, buf);
        }
        clogger.debug("internalReset", (Object)("CT_Data rc=" + res + " returns " + HexString.hexify(buf)));
        if (res < 0) {
            throw new CardTerminalException("CTAPICardTerminal: internalReset(), ERROR=" + res);
        }
        if (res < 2 || (buf[res - 2] & 0xFF) != 144) {
            throw new CardTerminalException("CTAPICardTerminal: internalReset(), No card inserted.");
        }
        byte[] response = new byte[res - 2];
        System.arraycopy(buf, 0, response, 0, res - 2);
        this.cardIdTable[slot] = cid = new CardID(this, slot, response);
        return cid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ResponseAPDU internalSendAPDU(int slot, CommandAPDU capdu, int ms) throws CardTerminalException {
        int res;
        byte[] resp = new byte[16386];
        if (!this.termopened) {
            throw new CardTerminalException("CTAPICardTerminal: internalSendAPDU(), Terminal not opened.");
        }
        byte[] com = capdu.getBytes();
        char resplen = (char)resp.length;
        byte fu = 0;
        if (slot > 0) {
            fu = (byte)(1 + slot);
        }
        CTAPICardTerminal cTAPICardTerminal = this;
        synchronized (cTAPICardTerminal) {
            this.processingAPDU = true;
            res = this.CT.CT_Data(this.ctn, fu, (byte)2, com, resplen, resp);
            this.processingAPDU = false;
        }
        if (res <= 0) {
            throw new CardTerminalException("CTAPICardTerminal: internalSendAPDU(), Error=" + res);
        }
        byte[] response = new byte[res];
        System.arraycopy(resp, 0, response, 0, res);
        return new ResponseAPDU(response);
    }

    @Override
    public void poll() throws CardTerminalException {
        boolean updateStatus = false;
        if (this.processingAPDU) {
            return;
        }
        byte[] newStatus = this.getStatus();
        for (int i = 0; i < newStatus.length; ++i) {
            if (newStatus[i] == this.cardStatus[i]) continue;
            if (newStatus[i] == 0) {
                this.cardIdTable[i] = null;
                this.cardStatus[i] = 0;
                this.cardRemoved(i);
                continue;
            }
            try {
                this.internalReset(i, 0);
                this.cardInserted(i);
            }
            catch (CardTerminalException cardTerminalException) {
                // empty catch block
            }
            updateStatus = true;
        }
        if (updateStatus) {
            this.cardStatus = this.getStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] sendTerminalCommand(byte[] com) throws CardTerminalException {
        int res;
        if (!this.termopened) {
            throw new CardTerminalException("CTAPICardTerminal: sendTerminalCommand(), Terminal not opened.");
        }
        byte[] resp = new byte[258];
        char buflen = (char)resp.length;
        CTAPICardTerminal cTAPICardTerminal = this;
        synchronized (cTAPICardTerminal) {
            res = this.CT.CT_Data(this.ctn, (byte)1, (byte)2, com, buflen, resp);
        }
        if (res < 2) {
            throw new CardTerminalException("CTAPICardTerminal: internalSendAPDU(), ERROR!");
        }
        byte[] response = new byte[res];
        System.arraycopy(resp, 0, response, 0, res);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getStatus() throws CardTerminalException {
        int len;
        byte[] buf = new byte[258];
        char lenbuf = (char)buf.length;
        CTAPICardTerminal cTAPICardTerminal = this;
        synchronized (cTAPICardTerminal) {
            len = this.CT.CT_Data(this.ctn, (byte)1, (byte)2, getStatus, lenbuf, buf);
        }
        if (len <= 0) {
            throw new CardTerminalException("CTAPICardTerminal: GetStatus() failed");
        }
        int i = 0;
        if (buf[0] == -128) {
            len = buf[1];
            i += 2;
        } else {
            len -= 2;
        }
        byte[] response = new byte[len];
        System.arraycopy(buf, i, response, 0, len);
        return response;
    }
}

