/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.factory;

import de.cardcontact.opencard.service.isocard.IsoCardService;
import de.cardcontact.opencard.service.isocard.TransparentCardService;
import java.util.Enumeration;
import java.util.Vector;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.CardType;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsoCardServiceFactory
extends CardServiceFactory {
    private static final byte[] Micardo20 = new byte[]{0, 0, 104, -46, 118, 0, 0, 40, -1, 5, 30};
    private static final byte[] Micardo21 = new byte[]{0, 0, 104, -46, 118, 0, 0, 40, -1, 5, 36};
    private static final byte[] Micardo23 = new byte[]{0, 0, 104, -46, 118, 0, 0, 40, -1, 5, 35};
    private static final byte[] Starcos30 = new byte[]{-128, 103, 4, 18, -80, 2, 1, -126, 1};
    private static final byte[] Starcos30_P5CC036 = new byte[]{-128, 103, 4, 20, -80, 1, 1, -126, 1};
    private static final byte[] JCOP41CL1 = new byte[]{65, 32, 0, 17, 51, -80, 74, 67, 79, 80, 52, 49, 86, 50};
    private static final byte[] JCOP41CL2 = new byte[]{65, 40, 0, 17, 51, -80, 74, 67, 79, 80, 52, 49, 86, 50};
    private static final byte[] JCOP41 = new byte[]{74, 67, 79, 80, 52, 49, 86, 50, 50};
    private static final byte[] TCOSICAOPHICL = new byte[]{65, 32, 0, 65, 34, -31, 2, 0, 100, 4, 0, 3, 0, 49};
    private static final byte[] TCOSICAOIFXCL = new byte[]{66, 0, 1, 51, -31};
    private static final byte[] EC = new byte[]{101, 99};
    private static Logger clogger = LoggerFactory.getLogger((String)(IsoCardServiceFactory.class.getName() + " Class"));

    @Override
    protected CardType getCardType(CardID cid, CardServiceScheduler scheduler) throws CardTerminalException {
        Vector<Class<IsoCardService>> serviceClasses = new Vector<Class<IsoCardService>>();
        serviceClasses.addElement(TransparentCardService.class);
        byte[] hb = cid.getHistoricals();
        int i = 0;
        if (hb != null) {
            if (hb[0] != 0 && hb[0] != -128) {
                clogger.info("[IsoCardServiceFactory.getCardType]", (Object)"Historical bytes do not indicate an ISO card");
                if (IsoCardServiceFactory.partialMatch(hb, JCOP41CL1)) {
                    i = 1089;
                    serviceClasses.addElement(IsoCardService.class);
                } else if (IsoCardServiceFactory.partialMatch(hb, JCOP41CL2)) {
                    i = 1089;
                    serviceClasses.addElement(IsoCardService.class);
                } else if (IsoCardServiceFactory.partialMatch(hb, JCOP41)) {
                    i = 1089;
                    serviceClasses.addElement(IsoCardService.class);
                } else if (IsoCardServiceFactory.partialMatch(hb, TCOSICAOPHICL)) {
                    i = 816;
                    serviceClasses.addElement(IsoCardService.class);
                } else if (IsoCardServiceFactory.partialMatch(hb, TCOSICAOIFXCL)) {
                    i = 816;
                    serviceClasses.addElement(IsoCardService.class);
                } else if (IsoCardServiceFactory.partialMatch(hb, EC)) {
                    i = 1280;
                    serviceClasses.addElement(IsoCardService.class);
                } else {
                    serviceClasses.addElement(IsoCardService.class);
                }
            } else {
                serviceClasses.addElement(IsoCardService.class);
                if (IsoCardServiceFactory.partialMatch(hb, Micardo20)) {
                    i = 288;
                } else if (IsoCardServiceFactory.partialMatch(hb, Micardo21)) {
                    i = 289;
                } else if (IsoCardServiceFactory.partialMatch(hb, Micardo23)) {
                    i = 291;
                } else if (IsoCardServiceFactory.partialMatch(hb, Starcos30)) {
                    i = 560;
                } else if (IsoCardServiceFactory.partialMatch(hb, Starcos30_P5CC036)) {
                    i = 560;
                }
            }
        } else {
            serviceClasses.addElement(IsoCardService.class);
        }
        CardType cardType = new CardType(i);
        cardType.setInfo(serviceClasses);
        return cardType;
    }

    @Override
    protected Enumeration getClasses(CardType type) {
        clogger.debug("[getClasses]", (Object)("card type is " + type.getType()));
        Vector serviceClasses = (Vector)type.getInfo();
        return serviceClasses.elements();
    }

    private static boolean partialMatch(byte[] hb, byte[] ref) {
        int i;
        if (hb.length < ref.length) {
            return false;
        }
        for (i = 0; i < ref.length && hb[i] == ref[i]; ++i) {
        }
        return i == ref.length;
    }
}

