/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.iso.fs;

import opencard.core.util.HexString;
import opencard.opt.iso.fs.CardFilePathComponent;

public class CardFileFileID
extends CardFilePathComponent {
    protected byte[] fileID = null;

    public CardFileFileID(String comp) {
        super(comp);
        if (!comp.startsWith(":")) {
            throw new IllegalArgumentException("file ID components must start with /");
        }
        if (comp.length() != 5) {
            throw new IllegalArgumentException("file ID component " + comp + " must contain two bytes");
        }
        this.fileID = new byte[]{(byte)(Integer.parseInt(comp.substring(1, 3), 16) & 0xFF), (byte)(Integer.parseInt(comp.substring(3), 16) & 0xFF)};
    }

    public CardFileFileID(short fileID) {
        this(new StringBuffer(":").append(HexString.hexifyShort(fileID & 0xFFFF)).toString());
    }

    public CardFileFileID(byte hi, byte lo) {
        this((short)((hi & 0xFF) << 8 | lo & 0xFF));
    }

    public short toShort() {
        return (short)(((this.fileID[0] & 0xFF) << 8 | this.fileID[1] & 0xFF) & 0xFFFF);
    }

    public byte[] toByteArray() {
        return this.fileID;
    }

    public void toByteArray(byte[] bites, int off) {
        bites[off] = this.fileID[0];
        bites[off + 1] = this.fileID[1];
    }

    @Override
    public boolean equals(Object comp) {
        if (!(comp instanceof CardFileFileID)) {
            return false;
        }
        return this.toShort() == ((CardFileFileID)comp).toShort();
    }

    public int hashCode() {
        return this.toShort();
    }
}

