/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.event;

import java.util.Enumeration;
import java.util.Vector;
import opencard.core.event.CTListener;
import opencard.core.event.CardTerminalEvent;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.Observer;
import opencard.core.terminal.Pollable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventGenerator
implements Observer,
Runnable {
    private static Logger clogger = LoggerFactory.getLogger((String)(EventGenerator.class.getName() + " Class"));
    private Vector listeners = new Vector();
    private static EventGenerator theGenerator = null;
    private Thread t = null;
    private static boolean running;
    private static int pollInterval;
    private Vector pollables = new Vector();

    public static EventGenerator getGenerator() {
        if (theGenerator == null) {
            theGenerator = new EventGenerator();
            CardTerminalRegistry.getRegistry().setObserver(theGenerator);
        }
        return theGenerator;
    }

    public void addCTListener(CTListener listener) {
        this.listeners.addElement(listener);
    }

    public void createEventsForPresentCards(CTListener ctListener) throws CardTerminalException {
        Enumeration e = CardTerminalRegistry.getRegistry().getCardTerminals();
        while (e.hasMoreElements()) {
            CardTerminal ct = (CardTerminal)e.nextElement();
            int slots = ct.getSlots();
            for (int i = 0; i < slots; ++i) {
                if (!ct.isCardPresent(i)) continue;
                ctListener.cardInserted(new CardTerminalEvent(ct, 1, i));
            }
        }
    }

    public void removeCTListener(CTListener ctListener) {
        this.listeners.removeElement(ctListener);
    }

    public void removeAllCTListener() {
        this.listeners = new Vector();
    }

    public void removeAllPollables() {
        this.pollables = new Vector();
    }

    public void setPollInterval(int duration) {
        pollInterval = duration;
    }

    public int getPollInterval() {
        return pollInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (running) {
            try {
                Thread.sleep(pollInterval);
                Vector vector = this.pollables;
                synchronized (vector) {
                    Enumeration e = this.pollables.elements();
                    while (e.hasMoreElements()) {
                        Pollable p = (Pollable)e.nextElement();
                        try {
                            p.poll();
                        }
                        catch (RuntimeException rte) {
                            clogger.debug("run", (Throwable)rte);
                        }
                        catch (CardTerminalException cte) {
                            clogger.debug("run", (Throwable)cte);
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    @Override
    public void updateCards(CardTerminal terminal, int slotID, boolean cardInserted) {
        clogger.debug("updateCards", (Object)("card " + (cardInserted ? "inserted" : "removed") + " slotID = " + slotID));
        if (!this.listeners.isEmpty()) {
            CTListener ctl = null;
            Enumeration e = this.listeners.elements();
            while (e.hasMoreElements()) {
                ctl = (CTListener)e.nextElement();
                try {
                    if (cardInserted) {
                        ctl.cardInserted(new CardTerminalEvent(terminal, 1, slotID));
                        continue;
                    }
                    ctl.cardRemoved(new CardTerminalEvent(terminal, 2, slotID));
                }
                catch (RuntimeException rte) {
                    clogger.error("updateCards", (Throwable)rte);
                }
                catch (CardTerminalException cte) {
                    clogger.error("updateCards", (Throwable)cte);
                }
            }
            clogger.debug("updateCards", (Object)"notified CTListeners");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateTerminals(Pollable p, boolean terminalAdded) {
        Vector vector = this.pollables;
        synchronized (vector) {
            if (terminalAdded) {
                clogger.debug("updateTerminals", (Object)("new pollable Terminal = " + p));
                this.pollables.addElement(p);
                try {
                    p.poll();
                }
                catch (RuntimeException rte) {
                    clogger.debug("run", (Throwable)rte);
                }
                catch (CardTerminalException cte) {
                    clogger.debug("run", (Throwable)cte);
                }
                if (this.t == null) {
                    this.t = new Thread((Runnable)this, "OCF Polling");
                    this.t.setDaemon(true);
                    running = true;
                    this.t.start();
                }
                return true;
            }
            clogger.debug("updateTerminals", (Object)("remove pollable Terminal = " + p));
            boolean r = this.pollables.removeElement(p);
            if (this.pollables.size() <= 0) {
                running = false;
                this.t = null;
            }
            return r;
        }
    }

    private EventGenerator() {
    }

    static {
        pollInterval = 500;
    }
}

