/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.terminal.jcopsim;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCOPSimCardTerminal
extends CardTerminal {
    private static final Logger clogger = LoggerFactory.getLogger((String)(JCOPSimCardTerminal.class.getName() + " Class"));
    public static final int DEFAULT_SOCKET_TIMEOUT = 5000;
    private static final int JCOP_RECV_BUFFER_SIZE = 65636;
    static final byte MTY_WAIT_FOR_CARD = 0;
    static final byte MTY_APDU_DATA = 1;
    static final byte MTY_STATUS = 2;
    static final byte MTY_ERROR_MESSAGE = 3;
    static final byte MTY_TERMINAL_INFO = 4;
    static final byte MTY_INIT_INFO = 5;
    static final byte MTY_ECHO = 6;
    static final byte MTY_DEBUG = 7;
    static final byte NODE_TERMINAL = 33;
    static final byte NODE_CARD = 0;
    static final int NOT_CONNECTED = 1;
    static final int SLOT_EMPTY = 2;
    static final int CARD_PRESENT = 4;
    static final int ERROR = 8;
    static final int PROTOCOL_T0 = 0;
    static final int PROTOCOL_T1 = 1;
    static final int PROTOCOL_TCL = 5;
    private Socket socket = null;
    private SocketAddress socketAddr;
    private int socketTimeout = 5000;
    private BufferedInputStream inStream = null;
    private BufferedOutputStream outStream = null;
    private CardID cid = null;
    private boolean connected = false;
    private byte[] jcopBuffer;

    public JCOPSimCardTerminal(String name, String type, String address, String host, int port, int timeout) throws CardTerminalException {
        super(name, type, address);
        this.socketAddr = new InetSocketAddress(host, port);
        this.jcopBuffer = new byte[65636];
        this.socketTimeout = timeout;
        this.addSlots(1);
    }

    @Override
    public CardID getCardID(int slotID) throws CardTerminalException {
        if (!this.connected) {
            this.connect();
        }
        if (!this.connected) {
            throw new CardTerminalException("JCOPSimCardTerminal: getCardID(), Terminal not opened.");
        }
        return this.cid;
    }

    @Override
    public boolean isCardPresent(int slotID) throws CardTerminalException {
        if (!this.connected) {
            this.connect();
        }
        return this.connected;
    }

    @Override
    public void open() throws CardTerminalException {
    }

    public void connect() throws CardTerminalException {
        if (this.connected) {
            return;
        }
        try {
            this.socket = new Socket();
            this.socket.connect(this.socketAddr, this.socketTimeout);
            this.socket.setSoTimeout(this.socketTimeout);
            this.outStream = new BufferedOutputStream(this.socket.getOutputStream());
            this.inStream = new BufferedInputStream(this.socket.getInputStream());
            this.connected = true;
        }
        catch (ConnectException connectException) {
        }
        catch (SocketTimeoutException socketTimeoutException) {
        }
        catch (Exception e) {
            throw new CardTerminalException("JCOPSimCardTerminal: Card terminal could not be opened! Reason: " + e.getLocalizedMessage());
        }
        try {
            if (this.connected) {
                byte[] data = new byte[]{0, 0, 0, 0};
                this.sendJcop((byte)0, (byte)33, data);
                int read = 0;
                read = this.readJcop((byte)0, this.jcopBuffer);
                byte[] scr = new byte[read];
                System.arraycopy(this.jcopBuffer, 0, scr, 0, read);
                this.cid = new CardID(this, 0, scr);
                this.cardInserted(0);
            }
        }
        catch (SocketException se) {
            this.close();
        }
        catch (Exception e) {
            this.close();
            throw new CardTerminalException("JCOPSimCardTerminal: Error in socket communication! Reason: " + e.getLocalizedMessage());
        }
    }

    @Override
    public void close() throws CardTerminalException {
        if (this.connected) {
            try {
                this.connected = false;
                this.outStream.close();
                this.inStream.close();
                this.outStream = null;
                this.inStream = null;
                this.socket.close();
            }
            catch (Exception e) {
                throw new CardTerminalException("JCOPSimCardTerminal: Error in socket communication! Reason: " + e.getLocalizedMessage());
            }
        }
    }

    @Override
    protected CardID internalReset(int slot, int ms) throws CardTerminalException {
        this.close();
        this.connect();
        return this.cid;
    }

    @Override
    protected ResponseAPDU internalSendAPDU(int slot, CommandAPDU capdu, int ms) throws CardTerminalException {
        if (!this.connected) {
            this.connect();
        }
        if (!this.connected) {
            throw new CardTerminalException("JCOPSimCardTerminal: Error sending APDU! No connection");
        }
        ResponseAPDU r = null;
        try {
            byte[] apdu = capdu.getBytes();
            this.sendJcop((byte)1, (byte)0, apdu);
            int read = 0;
            read = this.readJcop((byte)1, this.jcopBuffer);
            byte[] rsp = new byte[read];
            System.arraycopy(this.jcopBuffer, 0, rsp, 0, read);
            r = new ResponseAPDU(rsp);
        }
        catch (Exception e) {
            clogger.debug("internalSendAPDU()", (Object)("Error sending APDU: " + e.getMessage()));
            throw new CardTerminalException("JCOPSimCardTerminal: Error sending APDU! Reason: " + e.getLocalizedMessage());
        }
        return r;
    }

    private void sendJcop(byte mty, byte destNode, byte[] cmd) throws CardTerminalException {
        int length = cmd == null ? 0 : cmd.length;
        byte[] scr = new byte[4 + length];
        scr[0] = mty;
        scr[1] = destNode;
        scr[2] = (byte)(length / 256);
        scr[3] = (byte)length;
        if (cmd != null) {
            System.arraycopy(cmd, 0, scr, 4, length);
        }
        try {
            clogger.debug("sendJcop()", (Object)("SEND: " + HexString.dump(scr, 0, scr.length)));
            this.outStream.write(scr);
            this.outStream.flush();
        }
        catch (IOException e) {
            this.connected = false;
        }
    }

    private int readJcop(byte mty, byte[] buf) throws Exception {
        int totalBytesRead;
        int sizeRsp = -1;
        int read = 0;
        byte[] tmp = new byte[buf.length];
        read = this.inStream.read(tmp, 0, 4);
        if (read != 4) {
            this.connected = false;
            clogger.debug("readJcop()", (Object)("JCOP header not received! recv = " + HexString.dump(tmp, 0, read) + " (" + read + ")"));
            throw new CardTerminalException("JCOP header not received!");
        }
        if (tmp[0] != mty) {
            this.connected = false;
            clogger.debug("readJcop()", (Object)"Mismatch of message types");
            throw new CardTerminalException("Mismatch of message types");
        }
        sizeRsp = (tmp[2] & 0xFF) << 8 | tmp[3] & 0xFF;
        for (totalBytesRead = 0; totalBytesRead < sizeRsp; totalBytesRead += read) {
            read = this.inStream.read(tmp, 0, tmp.length);
            System.arraycopy(tmp, 0, buf, totalBytesRead, read);
        }
        if (this.inStream.available() > 0) {
            clogger.debug("readJcop()", (Object)("Warning: not all bytes were read! left = " + this.inStream.available()));
        }
        return totalBytesRead;
    }
}

