/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.cli;

import de.cardcontact.cli.ReaderConfigurationView;
import de.cardcontact.cli.TerminalManager;
import java.awt.AWTException;
import java.awt.Font;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.PrintStream;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;

public class TrayView
extends JFrame {
    private String iconPath = "cardcontact_24bit.gif";
    private ImageIcon ccIcon;
    final ReaderConfigurationView readerFrame;
    final JTextArea text = new JTextArea();
    final PopupMenu menu = new PopupMenu();
    private PrintStream out;

    public TrayView(TerminalManager tm) {
        super("Log");
        URL iconURL = TrayView.class.getResource(this.iconPath);
        this.ccIcon = new ImageIcon(iconURL);
        this.readerFrame = new ReaderConfigurationView(this.ccIcon.getImage(), tm);
        try {
            this.initSystemTray();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Font font = new Font("Monospaced", 0, 12);
        this.text.setFont(font);
    }

    private void initSystemTray() throws AWTException {
        String tooltip = "Card Updater Daemon";
        this.initPopUp();
        if (SystemTray.isSupported()) {
            TrayIcon trayIcon = new TrayIcon(this.ccIcon.getImage(), tooltip, this.menu);
            SystemTray systemTray = SystemTray.getSystemTray();
            systemTray.add(trayIcon);
            trayIcon.setImageAutoSize(true);
            trayIcon.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrayView.this.setVisible(true);
                }
            });
        }
        this.text.add(this.menu);
        this.text.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TrayView.this.menu.show(TrayView.this.text, e.getX(), e.getY());
            }
        });
    }

    private PopupMenu initPopUp() {
        MenuItem exit = new MenuItem("Exit");
        MenuItem log = new MenuItem("Show log");
        MenuItem clearLog = new MenuItem("Clear log");
        MenuItem showReader = new MenuItem("Reader Configuration");
        this.initLog();
        this.menu.add(log);
        this.menu.add(clearLog);
        this.menu.addSeparator();
        this.menu.add(showReader);
        this.menu.addSeparator();
        this.menu.add(exit);
        log.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrayView.this.setVisible(true);
            }
        });
        clearLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    TrayView.this.text.getDocument().remove(0, TrayView.this.text.getDocument().getLength());
                }
                catch (BadLocationException e1) {
                    System.out.println(e1.getMessage());
                }
            }
        });
        showReader.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrayView.this.readerFrame.showView();
            }
        });
        exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        return this.menu;
    }

    public void showLog() {
        this.setVisible(true);
    }

    private void initLog() {
        this.setSize(600, 700);
        this.setIconImage(this.ccIcon.getImage());
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(this.text);
        this.getContentPane().add(scrollPane);
        this.changeStandardOutput();
    }

    private void changeStandardOutput() {
        this.out = new PrintStream(System.out){

            @Override
            public void println(String s) {
                this.print(s);
                this.print("\n");
            }

            @Override
            public void print(String s) {
                TrayView.this.text.append(s);
                TrayView.this.text.setCaretPosition(TrayView.this.text.getDocument().getLength());
            }
        };
        System.setOut(this.out);
    }
}

