/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.tlv.cvc;

import de.cardcontact.tlv.ConstructedTLV;
import de.cardcontact.tlv.IntegerTLV;
import de.cardcontact.tlv.ObjectIdentifier;
import de.cardcontact.tlv.PrimitiveTLV;
import de.cardcontact.tlv.Sequence;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import de.cardcontact.tlv.Tag;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardVerifiableCertificate
extends Certificate {
    final Logger log;
    private static final Tag TAG_AT = new Tag(7, 64, true);
    private static final Tag TAG_CVC = new Tag(33, 64, true);
    private static final Tag TAG_BODY = new Tag(78, 64, true);
    private static final Tag TAG_CAR = new Tag(2, 64, false);
    private static final Tag TAG_CHR = new Tag(32, 64, false);
    private static final Tag TAG_PUK = new Tag(73, 64, true);
    private static final Tag TAG_PK_ALGORITHM = new Tag(6, 0, false);
    private static final Tag TAG_PK_MODULUS = new Tag(1, -128, false);
    private static final Tag TAG_PK_EXPONENT = new Tag(2, -128, false);
    private static final Tag TAG_PK_C_A = new Tag(2, -128, false);
    private static final Tag TAG_PK_C_B = new Tag(3, -128, false);
    private static final Tag TAG_PK_BASE_POINT = new Tag(4, -128, false);
    private static final Tag TAG_PK_ORDER = new Tag(5, -128, false);
    private static final Tag TAG_PK_PUBLIC_P = new Tag(6, -128, false);
    private static final Tag TAG_PK_COFACTOR = new Tag(7, -128, false);
    private static final Tag TAG_EXTENSIONS = new Tag(5, 64, true);
    private static final Tag TAG_EXTENSION = new Tag(19, 64, true);
    private static final ObjectIdentifier ID_TA_ECDSA = new ObjectIdentifier("0.4.0.127.0.7.2.2.2.2");
    private byte[] bin;
    private ConstructedTLV tlv;
    private ConstructedTLV cvc;
    private ConstructedTLV body;
    private PrimitiveTLV signature;
    private PublicKey publicKey;
    private PrimitiveTLV outerCar;
    private PrimitiveTLV outerSignature;
    private byte[] domainParam;

    public CardVerifiableCertificate(String type, byte[] certificate) throws CertificateException {
        block4: {
            super(type);
            this.log = LoggerFactory.getLogger(CardVerifiableCertificate.class);
            this.bin = certificate;
            try {
                this.tlv = new ConstructedTLV(this.bin);
                this.log.debug(this.tlv.dump(4));
                if (this.tlv.getTag().equals(TAG_AT)) {
                    this.cvc = (ConstructedTLV)this.tlv.get(0);
                    this.body = (ConstructedTLV)this.cvc.get(0);
                    this.signature = (PrimitiveTLV)this.cvc.get(1);
                    this.outerCar = (PrimitiveTLV)this.tlv.get(1);
                    this.outerSignature = (PrimitiveTLV)this.tlv.get(2);
                    break block4;
                }
                if (this.tlv.getTag().equals(TAG_CVC)) {
                    this.cvc = this.tlv;
                    this.body = (ConstructedTLV)this.cvc.get(0);
                    this.signature = (PrimitiveTLV)this.cvc.get(1);
                    break block4;
                }
                throw new CertificateException("This is not a Card Verifiable Certificate");
            }
            catch (TLVEncodingException e) {
                this.log.error("Decoding CVC", (Throwable)e);
                throw new CertificateParsingException(e);
            }
        }
    }

    public CardVerifiableCertificate(byte[] certificate) throws CertificateException {
        this("CVC", certificate);
    }

    private void extractPublicKey(String providerName) throws CertificateException, NoSuchProviderException {
        if (this.isECDSA(this.getPublicKeyOID())) {
            try {
                this.publicKey = this.getECPublicKey(providerName);
            }
            catch (TLVEncodingException e) {
                this.log.error("Extracting public key", (Throwable)e);
                throw new CertificateParsingException(e);
            }
        } else {
            this.publicKey = this.getRSAPublicKey(providerName);
        }
    }

    private boolean isECDSA(ObjectIdentifier oid) {
        int[] oidArray = oid.getObjectIdentifier();
        int[] ecdsa = ID_TA_ECDSA.getObjectIdentifier();
        for (int i = 0; i < ecdsa.length; ++i) {
            if (oidArray[i] == ecdsa[i]) continue;
            return false;
        }
        return true;
    }

    private ObjectIdentifier getPublicKeyOID() throws CertificateException {
        ConstructedTLV pdo = (ConstructedTLV)this.body.findTag(TAG_PUK, null);
        PrimitiveTLV oid = null;
        try {
            oid = (PrimitiveTLV)pdo.findTag(new Tag(6), null);
        }
        catch (TLVEncodingException e) {
            this.log.error("TLV decoding", (Throwable)e);
        }
        if (oid == null) {
            this.log.debug("No OID found.");
            throw new CertificateException("No OID found.");
        }
        return new ObjectIdentifier(oid.getValue());
    }

    public byte[] getAlgorithm() throws TLVEncodingException {
        ConstructedTLV pk = this.getPublicKeyFromCertificate();
        byte[] alg = ((PrimitiveTLV)pk.get(0)).getValue();
        return alg;
    }

    public BigInteger getModulus() throws TLVEncodingException {
        ConstructedTLV pk = this.getPublicKeyFromCertificate();
        byte[] mod = ((PrimitiveTLV)pk.get(1)).getValue();
        BigInteger modulus = this.byteArrayToUnsignedBigInteger(mod);
        return modulus;
    }

    public BigInteger getExponent() throws TLVEncodingException {
        ConstructedTLV pk = this.getPublicKeyFromCertificate();
        PrimitiveTLV exp = (PrimitiveTLV)pk.get(2);
        BigInteger exponent = this.byteArrayToUnsignedBigInteger(exp.getValue());
        return exponent;
    }

    private ECPublicKeySpec getECPublicKeySpecFromDomain() throws TLVEncodingException {
        ConstructedTLV pk = this.getPublicKeyFromCertificate();
        ConstructedTLV domain = new ConstructedTLV(this.domainParam);
        TLV tlv = pk.findTag(TAG_PK_MODULUS, null);
        byte[] prime = tlv == null ? domain.findTag(TAG_PK_MODULUS, null).getValue() : tlv.getValue();
        ECFieldFp field = new ECFieldFp(this.byteArrayToUnsignedBigInteger(prime));
        tlv = pk.findTag(TAG_PK_C_A, null);
        BigInteger a = tlv == null ? this.byteArrayToUnsignedBigInteger(domain.findTag(TAG_PK_C_A, null).getValue()) : this.byteArrayToUnsignedBigInteger(tlv.getValue());
        tlv = pk.findTag(TAG_PK_C_B, null);
        BigInteger b = tlv == null ? this.byteArrayToUnsignedBigInteger(domain.findTag(TAG_PK_C_B, null).getValue()) : this.byteArrayToUnsignedBigInteger(tlv.getValue());
        EllipticCurve curve = new EllipticCurve(field, a, b);
        tlv = pk.findTag(TAG_PK_BASE_POINT, null);
        byte[] basePoint = tlv == null ? domain.findTag(TAG_PK_BASE_POINT, null).getValue() : tlv.getValue();
        ECPoint g = this.getECPoint(basePoint);
        tlv = pk.findTag(TAG_PK_ORDER, null);
        BigInteger n = tlv == null ? this.byteArrayToUnsignedBigInteger(domain.findTag(TAG_PK_ORDER, null).getValue()) : this.byteArrayToUnsignedBigInteger(tlv.getValue());
        tlv = pk.findTag(TAG_PK_COFACTOR, null);
        byte h = tlv == null ? domain.findTag(TAG_PK_COFACTOR, null).getValue()[0] : tlv.getValue()[0];
        ECParameterSpec params = new ECParameterSpec(curve, g, n, h);
        tlv = pk.findTag(TAG_PK_PUBLIC_P, null);
        byte[] publicPoint = tlv == null ? domain.findTag(TAG_PK_PUBLIC_P, null).getValue() : tlv.getValue();
        ECPoint y = this.getECPoint(publicPoint);
        return new ECPublicKeySpec(y, params);
    }

    private ECPublicKeySpec getECPublicKeySpec() throws TLVEncodingException {
        ConstructedTLV pk = this.getPublicKeyFromCertificate();
        byte[] prime = pk.findTag(TAG_PK_MODULUS, null).getValue();
        ECFieldFp field = new ECFieldFp(this.byteArrayToUnsignedBigInteger(prime));
        BigInteger a = this.byteArrayToUnsignedBigInteger(pk.findTag(TAG_PK_C_A, null).getValue());
        BigInteger b = this.byteArrayToUnsignedBigInteger(pk.findTag(TAG_PK_C_B, null).getValue());
        EllipticCurve curve = new EllipticCurve(field, a, b);
        byte[] basePoint = pk.findTag(TAG_PK_BASE_POINT, null).getValue();
        ECPoint g = this.getECPoint(basePoint);
        BigInteger n = this.byteArrayToUnsignedBigInteger(pk.findTag(TAG_PK_ORDER, null).getValue());
        byte h = pk.findTag(TAG_PK_COFACTOR, null).getValue()[0];
        ECParameterSpec params = new ECParameterSpec(curve, g, n, h);
        byte[] publicPoint = pk.findTag(TAG_PK_PUBLIC_P, null).getValue();
        ECPoint y = this.getECPoint(publicPoint);
        return new ECPublicKeySpec(y, params);
    }

    private BigInteger byteArrayToUnsignedBigInteger(byte[] data) {
        byte[] absoluteValue = new byte[data.length + 1];
        System.arraycopy(data, 0, absoluteValue, 1, data.length);
        return new BigInteger(absoluteValue);
    }

    private ECPoint getECPoint(byte[] data) {
        int length = (data.length - 1) / 2;
        byte[] x = new byte[length];
        byte[] y = new byte[length];
        System.arraycopy(data, 1, x, 0, length);
        System.arraycopy(data, 1 + length, y, 0, length);
        ECPoint g = new ECPoint(this.byteArrayToUnsignedBigInteger(x), this.byteArrayToUnsignedBigInteger(y));
        return g;
    }

    private ConstructedTLV getPublicKeyFromCertificate() throws TLVEncodingException {
        ConstructedTLV pk = (ConstructedTLV)this.body.get(2);
        return pk;
    }

    @Override
    public byte[] getEncoded() {
        return this.bin;
    }

    private PublicKey getECPublicKey(String providerName) throws TLVEncodingException, NoSuchProviderException {
        PublicKey key = null;
        try {
            KeyFactory fact = null;
            fact = providerName != null ? KeyFactory.getInstance("EC", providerName) : KeyFactory.getInstance("EC");
            ECPublicKeySpec spec = this.domainParam != null ? this.getECPublicKeySpecFromDomain() : this.getECPublicKeySpec();
            key = fact.generatePublic(spec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            this.log.error("Decoding public key", (Throwable)e);
        }
        return key;
    }

    private PublicKey getRSAPublicKey(String providerName) throws CertificateException {
        ConstructedTLV puk = (ConstructedTLV)this.body.findTag(TAG_PUK, null);
        if (puk == null) {
            throw new CertificateException("Certificate doesn't contain a public key object.");
        }
        byte[] mod = ((PrimitiveTLV)puk.findTag(TAG_PK_MODULUS, null)).getValue();
        BigInteger modulus = this.byteArrayToUnsignedBigInteger(mod);
        PrimitiveTLV exp = (PrimitiveTLV)puk.findTag(TAG_PK_EXPONENT, null);
        BigInteger exponent = this.byteArrayToUnsignedBigInteger(exp.getValue());
        RSAPublicKeySpec spec = new RSAPublicKeySpec(modulus, exponent);
        PublicKey key = null;
        try {
            KeyFactory fact = null;
            fact = providerName != null ? KeyFactory.getInstance("RSA", providerName) : KeyFactory.getInstance("RSA");
            key = fact.generatePublic(spec);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
            this.log.error("Decoding RSA key", (Throwable)e);
        }
        return key;
    }

    public PublicKey getPublicKey(byte[] domainParam) {
        this.domainParam = domainParam;
        try {
            this.extractPublicKey(null);
        }
        catch (NoSuchProviderException | CertificateException e) {
            e.printStackTrace();
        }
        return this.publicKey;
    }

    public PublicKey getPublicKey(String providerName) {
        try {
            this.extractPublicKey(providerName);
        }
        catch (NoSuchProviderException | CertificateException e) {
            e.printStackTrace();
        }
        return this.publicKey;
    }

    @Override
    public PublicKey getPublicKey() {
        try {
            this.extractPublicKey(null);
        }
        catch (NoSuchProviderException | CertificateException e) {
            e.printStackTrace();
        }
        return this.publicKey;
    }

    public void setDomainParameter(byte[] param) {
        ConstructedTLV tlv = null;
        try {
            tlv = new ConstructedTLV(param);
        }
        catch (TLVEncodingException e) {
            e.printStackTrace();
        }
        ConstructedTLV publicKey = (ConstructedTLV)this.body.findTag(TAG_PUK, null);
        publicKey.add(tlv.findTag(TAG_PK_MODULUS, null));
        publicKey.add(tlv.findTag(TAG_PK_C_A, null));
        publicKey.add(tlv.findTag(TAG_PK_C_B, null));
        publicKey.add(tlv.findTag(TAG_PK_BASE_POINT, null));
        publicKey.add(tlv.findTag(TAG_PK_ORDER, null));
        publicKey.add(tlv.findTag(TAG_PK_COFACTOR, null));
    }

    public byte[] getDomainParameter() {
        ConstructedTLV publicKey = (ConstructedTLV)this.body.findTag(TAG_PUK, null);
        return publicKey.getBytes();
    }

    @Override
    public String toString() {
        return this.tlv.dump();
    }

    public byte[] getCAR() {
        PrimitiveTLV car = (PrimitiveTLV)this.body.findTag(TAG_CAR, null);
        return car.getValue();
    }

    public byte[] getOuterCAR() {
        if (this.outerCar != null) {
            return this.outerCar.getValue();
        }
        return null;
    }

    public byte[] getOuterCARTLV() throws CertificateException {
        if (this.outerCar != null) {
            return this.outerCar.getBytes();
        }
        throw new CertificateException("Certificate has no Outer Cerification Authority Reference");
    }

    public byte[] getCHR() {
        PrimitiveTLV chr = (PrimitiveTLV)this.body.findTag(TAG_CHR, null);
        return chr.getValue();
    }

    private byte[] getDataTBS() {
        if (this.outerCar != null) {
            byte[] cvcb = this.cvc.getBytes();
            byte[] outerCarb = this.outerCar.getBytes();
            byte[] tbs = new byte[cvcb.length + outerCarb.length];
            System.arraycopy(cvcb, 0, tbs, 0, cvcb.length);
            System.arraycopy(outerCarb, 0, tbs, cvcb.length, outerCarb.length);
            return tbs;
        }
        return this.body.getBytes();
    }

    public TLV getExtension(ObjectIdentifier extid) {
        System.out.println(this.body.dump());
        ConstructedTLV exts = (ConstructedTLV)this.body.findTag(TAG_EXTENSIONS, null);
        if (exts == null) {
            return null;
        }
        for (int i = 0; i < exts.getChildCount(); ++i) {
            ConstructedTLV ext = (ConstructedTLV)exts.get(i);
            PrimitiveTLV oid = (PrimitiveTLV)ext.get(0);
            if (!extid.equals(oid)) continue;
            return ext.get(1);
        }
        return null;
    }

    @Override
    public void verify(PublicKey puk) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(puk, (String)null);
    }

    @Override
    public void verify(PublicKey puk, String providerName) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature verifier = providerName == null ? Signature.getInstance("SHA256withECDSA") : Signature.getInstance("SHA256withECDSA", providerName);
        verifier.initVerify(puk);
        verifier.update(this.getDataTBS());
        byte[] wrappedSignature = this.outerSignature == null ? CardVerifiableCertificate.wrapSignature(this.signature.getValue()) : CardVerifiableCertificate.wrapSignature(this.outerSignature.getValue());
        boolean verified = verifier.verify(wrappedSignature);
        if (!verified) {
            throw new CertificateException("Certificate verification failed.");
        }
    }

    public byte[] getBody() {
        return this.body.getBytes();
    }

    public byte[] getCVC() {
        return this.cvc.getBytes();
    }

    public byte[] getSignature() {
        return this.signature.getBytes();
    }

    public byte[] getOuterSignature() throws CertificateException {
        if (this.outerSignature != null) {
            return this.outerSignature.getBytes();
        }
        throw new CertificateException("Certificate has no Outer Signature");
    }

    public static byte[] wrapSignature(byte[] signature) {
        int length = signature.length / 2;
        byte[] ib = new byte[length];
        System.arraycopy(signature, 0, ib, 0, length);
        BigInteger r = new BigInteger(1, ib);
        System.arraycopy(signature, length, ib, 0, length);
        BigInteger s = new BigInteger(1, ib);
        Sequence sequence = new Sequence();
        sequence.add(new IntegerTLV(r));
        sequence.add(new IntegerTLV(s));
        return sequence.getBytes();
    }

    public static byte[] unwrapSignature(byte[] signature, int keyLength) throws TLVEncodingException {
        ConstructedTLV sequence = new ConstructedTLV(signature);
        byte[] r = sequence.get(0).getValue();
        byte[] s = sequence.get(1).getValue();
        byte[] wrapped = new byte[keyLength * 2];
        int len = r.length > keyLength ? keyLength : r.length;
        System.arraycopy(r, r.length - len, wrapped, 0, len);
        len = s.length > keyLength ? keyLength : s.length;
        System.arraycopy(s, s.length - len, wrapped, keyLength, len);
        return wrapped;
    }
}

