/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.tlv;

import de.cardcontact.tlv.TLVEncodingException;

public class ParseBuffer {
    private byte[] buffer = null;
    private int cursor;
    private int mark;
    private int limit;

    public ParseBuffer(byte[] newBuffer, int newCursor, int newLength) {
        this.buffer = newBuffer;
        this.cursor = newCursor;
        this.mark = newCursor;
        this.limit = newCursor + newLength;
    }

    public ParseBuffer(byte[] newBuffer) {
        this(newBuffer, 0, newBuffer.length);
    }

    public void mark() {
        this.mark = this.cursor;
    }

    public void reset() {
        this.cursor = this.mark;
    }

    public int remaining() {
        return this.limit - this.cursor;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        if (limit > this.buffer.length) {
            throw new IllegalArgumentException("Can't set new limit if it exceeds buffer");
        }
        this.limit = limit;
    }

    public void setLength(int newLength) {
        if (newLength >= 0) {
            if (this.cursor + newLength > this.buffer.length) {
                throw new IllegalArgumentException("Can't set new length if it exceeds buffer");
            }
            this.limit = this.cursor + newLength;
        }
    }

    public boolean hasRemaining() {
        return this.cursor < this.limit;
    }

    public byte get() throws TLVEncodingException {
        if (this.cursor >= this.limit) {
            throw new TLVEncodingException("End of buffer");
        }
        return this.buffer[this.cursor++];
    }

    public ParseBuffer get(byte[] dst, int offset, int length) throws TLVEncodingException {
        if (length > this.limit - this.cursor) {
            throw new TLVEncodingException("Invalid length field");
        }
        System.arraycopy(this.buffer, this.cursor, dst, offset, length);
        this.cursor += length;
        return this;
    }

    public int getUnsignedWord() throws TLVEncodingException {
        if (this.cursor + 1 >= this.limit) {
            throw new TLVEncodingException("End of buffer");
        }
        int value = (this.buffer[this.cursor++] & 0xFF) << 8;
        return value += this.buffer[this.cursor++] & 0xFF;
    }

    public int getDGILength() throws TLVEncodingException {
        int i = 1;
        if (this.cursor >= this.limit) {
            throw new TLVEncodingException("End of buffer");
        }
        if (this.buffer[this.cursor] == -1) {
            i = 2;
            ++this.cursor;
        }
        if (this.cursor + i > this.limit) {
            throw new TLVEncodingException("Invalid DGI length field");
        }
        int length = 0;
        while (i > 0) {
            length = length << 8 | this.buffer[this.cursor++] & 0xFF;
            --i;
        }
        return length;
    }

    public int getDERLength() throws TLVEncodingException {
        int i = 1;
        if (this.cursor >= this.limit) {
            throw new TLVEncodingException("End of buffer");
        }
        if ((this.buffer[this.cursor] & 0x80) == 128) {
            i = this.buffer[this.cursor] & 7;
            ++this.cursor;
            if (i == 0) {
                return -1;
            }
        }
        if (i > 4) {
            throw new TLVEncodingException("More than 4 bytes in length field");
        }
        if (this.cursor + i > this.limit) {
            throw new TLVEncodingException("Invalid DER length field");
        }
        int length = 0;
        while (i > 0) {
            length = length << 8 | this.buffer[this.cursor++] & 0xFF;
            --i;
        }
        return length;
    }

    public int getTag() throws TLVEncodingException {
        int value;
        if (this.cursor >= this.limit) {
            throw new TLVEncodingException("End of buffer");
        }
        if (((value = this.buffer[this.cursor++] & 0xFF) & 0x1F) == 31) {
            int i = 4;
            do {
                if (this.cursor >= this.limit) {
                    throw new TLVEncodingException("End of buffer");
                }
                value <<= 8;
            } while (((value += this.buffer[this.cursor++] & 0xFF) & 0x80) == 128 && --i > 0);
        }
        return value;
    }
}

