/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.factory;

import de.cardcontact.opencard.factory.IsoCardServiceFactory;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import java.util.Enumeration;
import java.util.Vector;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.CardType;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartCardHSMCardServiceFactory
extends CardServiceFactory {
    private static final byte[] SMARTCARDHSM = new byte[]{-128, 49, -127, 84, 72, 83, 77, 49, 115, -128, 33, 64, -127, 7};
    private static final byte[] GENERIC_JCOP241 = new byte[]{74, 67, 79, 80, 118, 50, 52, 49};
    private static final byte[] GENERIC_JCOP242 = new byte[]{74, 67, 79, 80, 50, 52, 50};
    private static final byte[] GENERIC_JCOP3 = new byte[]{-128, 115, -56, 33, 19, 102, 5, 3, 99, 81, 0, 2};
    private static final byte[] SOC_JCOP = new byte[]{59, -128, -128, 1, 1};
    private static Logger clogger = LoggerFactory.getLogger((String)(IsoCardServiceFactory.class.getName() + " Class"));

    @Override
    protected CardType getCardType(CardID cid, CardServiceScheduler scheduler) throws CardTerminalException {
        Vector<Class<SmartCardHSMCardService>> serviceClasses = new Vector<Class<SmartCardHSMCardService>>();
        byte[] hb = cid.getHistoricals();
        int i = 0;
        if (hb != null && (SmartCardHSMCardServiceFactory.partialMatch(hb, SMARTCARDHSM) || SmartCardHSMCardServiceFactory.partialMatch(hb, GENERIC_JCOP241) || SmartCardHSMCardServiceFactory.partialMatch(hb, GENERIC_JCOP242) || SmartCardHSMCardServiceFactory.partialMatch(hb, GENERIC_JCOP3)) || SmartCardHSMCardServiceFactory.partialMatch(cid.getATR(), SOC_JCOP)) {
            i = 2304;
            serviceClasses.addElement(SmartCardHSMCardService.class);
        }
        CardType cardType = new CardType(i);
        cardType.setInfo(serviceClasses);
        return cardType;
    }

    @Override
    protected Enumeration getClasses(CardType type) {
        clogger.info("[getClasses]", (Object)("card type is " + type.getType()));
        Vector serviceClasses = (Vector)type.getInfo();
        return serviceClasses.elements();
    }

    private static boolean partialMatch(byte[] hb, byte[] ref) {
        int i;
        if (hb.length < ref.length) {
            return false;
        }
        for (i = 0; i < ref.length && hb[i] == ref[i]; ++i) {
        }
        return i == ref.length;
    }
}

