/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.cli;

import de.cardcontact.cli.ClientProperties;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Observable;
import opencard.core.service.CardIDFilter;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalRegistry;

public class TerminalManager
extends Observable
implements CardIDFilter {
    private HashSet<String> ignored;
    private String selectedTerminal;
    private CardTerminalRegistry ctr;
    private ClientProperties clientProperties = new ClientProperties();

    public TerminalManager() {
        this.ctr = CardTerminalRegistry.getRegistry();
        this.ignored = this.clientProperties.getIgnoredReader();
        this.selectedTerminal = this.clientProperties.getReaderName();
    }

    @Override
    public boolean isCandidate(CardID cardID) {
        CardTerminal terminal = cardID.getCardTerminal();
        HashSet<String> ignoreSet = this.clientProperties.getIgnoredReader();
        return !ignoreSet.contains(terminal.getName());
    }

    public HashSet<String> getAllTerminals() {
        HashSet<String> all = this.getValidTerminals();
        all.addAll(this.ignored);
        return all;
    }

    public HashSet<String> getValidTerminals() {
        HashSet<String> valid = new HashSet<String>();
        Enumeration ctlist = this.ctr.getCardTerminals();
        while (ctlist.hasMoreElements()) {
            CardTerminal ct = (CardTerminal)ctlist.nextElement();
            String reader = ct.getName();
            if (this.ignored.contains(reader)) continue;
            valid.add(reader);
        }
        return valid;
    }

    public HashSet<String> getIgnoredTerminals() {
        return this.ignored;
    }

    public void setIgnoredTerminals(HashSet<String> ignored) {
        this.ignored = ignored;
    }

    public void ignoreTerminal(String terminal) {
        this.ignored.add(terminal);
    }

    public void approveTerminal(String terminal) {
        this.ignored.remove(terminal);
    }

    public String getSelectedTerminal() {
        return this.selectedTerminal;
    }

    public void setSelectedTerminal(String terminal) {
        this.selectedTerminal = terminal;
    }

    public void saveSettings() {
        this.clientProperties.saveIgnoredReader(this.ignored);
        this.clientProperties.saveReaderName(this.selectedTerminal);
        this.setChanged();
        this.notifyObservers();
    }

    public void discardChanges() {
        this.ignored = this.clientProperties.getIgnoredReader();
        this.selectedTerminal = this.clientProperties.getReaderName();
    }
}

