/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.terminal;

import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.Slot;
import opencard.core.util.APDUTracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SlotChannel {
    private Logger ilogger = LoggerFactory.getLogger((String)(SlotChannel.class.getName() + " Object"));
    private APDUTracer aPDUTracer = null;
    private final CardTerminal terminal;
    private final int slotID;
    private boolean slotChannelState = false;
    private Object scheduler;
    private Object lockHandle;

    public SlotChannel(CardTerminal terminal, int slotID, Object lockHandle) {
        this.terminal = terminal;
        this.slotID = slotID;
        this.slotChannelState = true;
        this.lockHandle = lockHandle;
    }

    public Object getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Object scheduler) {
        this.scheduler = scheduler;
    }

    public ResponseAPDU sendAPDU(CommandAPDU capdu) throws CardTerminalException {
        if (this.aPDUTracer == null) {
            return this.terminal.sendAPDU(this, capdu);
        }
        this.aPDUTracer.traceCommandAPDU(this, capdu);
        ResponseAPDU rapdu = this.terminal.sendAPDU(this, capdu);
        this.aPDUTracer.traceResponseAPDU(this, rapdu);
        return rapdu;
    }

    @Deprecated
    public ResponseAPDU sendAPDU(CommandAPDU capdu, int ms) throws CardTerminalException {
        return this.terminal.sendAPDU(this, capdu);
    }

    @Deprecated
    public Slot getSlot() {
        return this.terminal.getSlot(this.slotID);
    }

    public int getSlotNumber() {
        return this.slotID;
    }

    public CardTerminal getCardTerminal() {
        return this.terminal;
    }

    public Object getLockHandle() {
        return this.lockHandle;
    }

    @Deprecated
    public CardID reset(int ms) throws CardTerminalException {
        return this.terminal.reset(this);
    }

    public CardID reset(boolean warm) throws CardTerminalException {
        CardID cid = this.terminal.reset(this, warm);
        if (this.aPDUTracer != null) {
            this.aPDUTracer.traceAnswerToReset(this, cid);
        }
        return cid;
    }

    public CardID reset() throws CardTerminalException {
        return this.reset(false);
    }

    public boolean isOpen() {
        return this.slotChannelState;
    }

    public void close() throws CardTerminalException {
        this.ilogger.debug("close", (Object)"closing channel");
        this.slotChannelState = false;
        this.terminal.closeSlotChannel(this);
    }

    public CardID getCardID() throws CardTerminalException {
        return this.terminal.getCardID(this.slotID);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append("\n+ state ").append(this.slotChannelState ? " open" : " closed");
        return sb.toString();
    }

    public void setAPDUTracer(APDUTracer tracer) {
        this.aPDUTracer = tracer;
    }

    public APDUTracer getAPDUTracer() {
        return this.aPDUTracer;
    }
}

