/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.service.smartcardhsm;

import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMPrivateKeySpec;
import de.cardcontact.tlv.ByteBuffer;
import de.cardcontact.tlv.ConstructedTLV;
import de.cardcontact.tlv.ObjectIdentifier;
import de.cardcontact.tlv.PrimitiveTLV;
import de.cardcontact.tlv.Tag;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECField;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.EllipticCurve;

public class SmartCardHSMECPrivateKeySpec
extends SmartCardHSMPrivateKeySpec {
    public static final byte[] TA_ECDSA_SHA_256 = new byte[]{4, 0, 127, 0, 7, 2, 2, 2, 2, 3};
    private ECParameterSpec domainParameter;
    private EllipticCurve curve;
    private ECFieldFp field;
    private int keySize;

    public SmartCardHSMECPrivateKeySpec(String car, String chr, AlgorithmParameterSpec params) {
        super(car, chr);
        if (params instanceof ECParameterSpec) {
            this.domainParameter = (ECParameterSpec)params;
        } else {
            try {
                AlgorithmParameters parameters = AlgorithmParameters.getInstance("EC", "SunEC");
                parameters.init(params);
                this.domainParameter = parameters.getParameterSpec(ECParameterSpec.class);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid domain parameter " + e.getLocalizedMessage());
            }
        }
        this.algorithm = TA_ECDSA_SHA_256;
        this.curve = this.domainParameter.getCurve();
        this.field = (ECFieldFp)this.curve.getField();
        this.keySize = this.field.getFieldSize();
    }

    public SmartCardHSMECPrivateKeySpec(AlgorithmParameterSpec params) {
        this("UT-00000", "UT-00000", params);
    }

    public ECParameterSpec getECParameterSpec() {
        return this.domainParameter;
    }

    public int getKeySize() {
        return this.keySize;
    }

    @Override
    protected ConstructedTLV encodeKeyParams() {
        ConstructedTLV puk = new ConstructedTLV(new Tag(73, 64, true));
        puk.add(new ObjectIdentifier(this.getAlgorithm()));
        ECField field = this.domainParameter.getCurve().getField();
        int keySize = field.getFieldSize();
        byte[] v = SmartCardHSMECPrivateKeySpec.unsignedBigIntegerToByteArray(((ECFieldFp)field).getP(), keySize);
        puk.add(new PrimitiveTLV(new Tag(1, -128, false), v));
        v = SmartCardHSMECPrivateKeySpec.unsignedBigIntegerToByteArray(this.domainParameter.getCurve().getA(), keySize);
        puk.add(new PrimitiveTLV(new Tag(2, -128, false), v));
        v = SmartCardHSMECPrivateKeySpec.unsignedBigIntegerToByteArray(this.domainParameter.getCurve().getB(), keySize);
        puk.add(new PrimitiveTLV(new Tag(3, -128, false), v));
        ByteBuffer basePointG = new ByteBuffer();
        basePointG.append((byte)4);
        basePointG.append(SmartCardHSMECPrivateKeySpec.unsignedBigIntegerToByteArray(this.domainParameter.getGenerator().getAffineX(), keySize));
        basePointG.append(SmartCardHSMECPrivateKeySpec.unsignedBigIntegerToByteArray(this.domainParameter.getGenerator().getAffineY(), keySize));
        puk.add(new PrimitiveTLV(new Tag(4, -128, false), basePointG.getBytes()));
        v = SmartCardHSMECPrivateKeySpec.unsignedBigIntegerToByteArray(this.domainParameter.getOrder(), keySize);
        puk.add(new PrimitiveTLV(new Tag(5, -128, false), v));
        byte[] cofactor = new byte[]{(byte)this.domainParameter.getCofactor()};
        puk.add(new PrimitiveTLV(new Tag(7, -128, false), cofactor));
        return puk;
    }

    public byte[] getBasePointG() throws IOException {
        ByteArrayOutputStream basePointG = new ByteArrayOutputStream();
        basePointG.write(4);
        basePointG.write(SmartCardHSMECPrivateKeySpec.unsignedBigIntegerToByteArray(this.domainParameter.getGenerator().getAffineX(), this.keySize));
        basePointG.write(SmartCardHSMECPrivateKeySpec.unsignedBigIntegerToByteArray(this.domainParameter.getGenerator().getAffineY(), this.keySize));
        return basePointG.toByteArray();
    }
}

