/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.service.smartcardhsm;

import de.cardcontact.tlv.ConstructedTLV;
import de.cardcontact.tlv.PrimitiveTLV;
import de.cardcontact.tlv.Sequence;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import java.security.MessageDigest;
import java.security.PublicKey;

public class CertificateDescription {
    public static byte[] buildCertDescription(String label, PublicKey subjectPublicKey, byte[] certEF) throws TLVEncodingException {
        return CertificateDescription.buildCertDescription(label, null, subjectPublicKey, certEF);
    }

    public static byte[] computeSubjectKeyID(PublicKey key) {
        byte[] sha1 = null;
        try {
            Sequence pk = (Sequence)TLV.factory(key.getEncoded());
            byte[] hashinp = pk.get(1).getValue();
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(hashinp, 1, hashinp.length - 1);
            sha1 = md.digest();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sha1;
    }

    public static byte[] buildCertDescription(String label, byte[] commonObjectFlags, PublicKey subjectPublicKey, byte[] certEF) throws TLVEncodingException {
        ConstructedTLV tlv = new ConstructedTLV(48);
        ConstructedTLV commonObjectAttributes = new ConstructedTLV(48);
        commonObjectAttributes.add(new PrimitiveTLV(12, label.getBytes()));
        if (commonObjectFlags == null) {
            commonObjectFlags = new byte[]{6, 64};
        }
        commonObjectAttributes.add(new PrimitiveTLV(3, commonObjectFlags));
        ConstructedTLV commonCertificateAttributes = new ConstructedTLV(48);
        commonCertificateAttributes.add(new PrimitiveTLV(4, CertificateDescription.computeSubjectKeyID(subjectPublicKey)));
        ConstructedTLV typeAttributes = new ConstructedTLV(161);
        ConstructedTLV x509CertificateAttributes = new ConstructedTLV(48);
        ConstructedTLV path = new ConstructedTLV(48);
        path.add(new PrimitiveTLV(4, certEF));
        x509CertificateAttributes.add(path);
        typeAttributes.add(x509CertificateAttributes);
        tlv.add(commonObjectAttributes);
        tlv.add(commonCertificateAttributes);
        tlv.add(typeAttributes);
        return tlv.getBytes();
    }

    public byte[] buildCertDescription(String label) throws TLVEncodingException {
        ConstructedTLV tlv = new ConstructedTLV(48);
        ConstructedTLV labelSequence = new ConstructedTLV(48);
        labelSequence.add(new PrimitiveTLV(12, label.getBytes()));
        tlv.add(labelSequence);
        return tlv.getBytes();
    }

    public String getLabel(byte[] enc) throws TLVEncodingException {
        ConstructedTLV tlv = new ConstructedTLV(enc);
        if ((tlv = (ConstructedTLV)tlv.get(0)).getElements() < 1) {
            throw new TLVEncodingException("The description is wrong encoded");
        }
        String label = new String(tlv.get(0).getValue());
        return label;
    }
}

