/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.kess.receivefromescrow;

import java.util.ArrayList;
import java.util.List;
import org.openscdp.kess.receivefromescrow.ReceiveKeyFromEscrowForm;
import org.openscdp.pkicard.escrow.receive.GenerateExchangeKeyAction;
import org.openscdp.pkicard.escrow.receive.ReceiveKeyFromEscrowAction;
import org.openscdp.pkicard.escrow.receive.ReceiveKeyFromEscrowSharedServiceRequest;
import org.openscdp.pkicard.escrow.receive.RewrapKeyForReceiverAction;
import org.openscdp.pkidb.dto.ServiceRequestDTO;
import org.openscdp.pkidm.action.ServiceRequestAction;
import org.openscdp.pkidm.action.ServiceRequestSaveAction;
import org.openscdp.pkidm.json.JSONAction;
import org.openscdp.pkidm.servicerequest.ActionList;
import org.openscdp.pkidm.servicerequest.ServiceRequest;
import org.openscdp.pkidm.servicerequest.ServiceRequestCreationValidator;
import org.openscdp.pkidm.servicerequest.ServiceRequestForm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiveKeyFromEscrowServiceRequest
extends ReceiveKeyFromEscrowSharedServiceRequest
implements ServiceRequestForm,
ActionList,
ServiceRequestCreationValidator {
    public static final String PROCESS = "ReceiveKeyFromEscrow";
    private final Logger logger = LoggerFactory.getLogger(ReceiveKeyFromEscrowServiceRequest.class);
    private ReceiveKeyFromEscrowForm form;

    public ReceiveKeyFromEscrowServiceRequest(ServiceRequestDTO dto) {
        super(dto);
    }

    public boolean processForm(JSONAction data) {
        switch (data.action) {
            case "action.save": 
            case "action.submit": {
                ReceiveKeyFromEscrowForm form = this.getForm();
                if (!form.setFields(data.args)) {
                    return false;
                }
                this.commitForm();
            }
        }
        return true;
    }

    public ReceiveKeyFromEscrowForm getForm() {
        if (this.form == null) {
            this.form = new ReceiveKeyFromEscrowForm(this);
        }
        return this.form;
    }

    public List<String> getActionList() {
        ArrayList<String> actions = new ArrayList<String>();
        List<ServiceRequestAction> list = this.getActions();
        list.forEach(e -> actions.add(e.getKeyWithContext()));
        return actions;
    }

    public ServiceRequestAction getActionFor(JSONAction action) {
        List<ServiceRequestAction> list = this.getActions();
        for (ServiceRequestAction a : list) {
            if (!a.getKey().equals(action.action)) continue;
            return a;
        }
        return null;
    }

    protected List<ServiceRequestAction> getActions() {
        GenerateExchangeKeyAction action;
        ArrayList<ServiceRequestAction> list = new ArrayList<ServiceRequestAction>();
        if (this.getLifeCycle() <= 2) {
            list.add((ServiceRequestAction)new ServiceRequestSaveAction((ServiceRequest)this));
        }
        if (this.getLifeCycle() == 2 && (action = new GenerateExchangeKeyAction((ReceiveKeyFromEscrowSharedServiceRequest)this)).preFlightCheck()) {
            list.add((ServiceRequestAction)new GenerateExchangeKeyAction((ReceiveKeyFromEscrowSharedServiceRequest)this));
        }
        if (this.getLifeCycle() == 3 && this.isCAOfficer()) {
            list.add((ServiceRequestAction)new ServiceRequestSaveAction((ServiceRequest)this));
            action = new RewrapKeyForReceiverAction((ReceiveKeyFromEscrowSharedServiceRequest)this);
            if (action.preFlightCheck()) {
                list.add((ServiceRequestAction)action);
            }
        }
        if (this.getLifeCycle() == 6 && (action = new ReceiveKeyFromEscrowAction((ReceiveKeyFromEscrowSharedServiceRequest)this)).preFlightCheck()) {
            list.add((ServiceRequestAction)action);
        }
        return list;
    }

    public void commitForm() {
        if (this.getForm().saveForm()) {
            if (this.getLifeCycle() == 1) {
                this.setLifeCycle(2);
            }
            this.setStatusInfo("Data saved");
            this.commit(this.userId, null);
        }
    }

    public boolean validateCreation() {
        this.dto.setTitle("Receive Key From Escrow");
        this.dto.setState("Created");
        return true;
    }
}

