/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.service.smartcardhsm;

import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMKeySpec;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMSecretKey;
import de.cardcontact.tlv.PrimitiveTLV;
import de.cardcontact.tlv.Sequence;
import de.cardcontact.tlv.Tag;
import javax.crypto.SecretKey;

public class SmartCardHSMSecretKeySpec
extends SmartCardHSMKeySpec {
    private int keysize;
    private SmartCardHSMSecretKey wrappingKey = null;

    public SmartCardHSMSecretKeySpec(int keysize) {
        if (keysize != 128 && keysize != 192 && keysize != 256) {
            throw new IllegalArgumentException("Key size must be 128, 192 or 256");
        }
        this.keysize = keysize;
    }

    public void setWrappingKey(SecretKey wrappingKey) {
        this.wrappingKey = (SmartCardHSMSecretKey)wrappingKey;
    }

    @Override
    protected void encodeKeyParams(Sequence cdata) {
        super.encodeKeyParams(cdata);
        if (this.wrappingKey != null) {
            cdata.add(new PrimitiveTLV(new Tag(19, -128, false), new byte[]{this.wrappingKey.getKeyRef()}));
        }
    }

    public int getKeySize() {
        return this.keysize;
    }
}

