/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.kess.joingroup;

import java.util.ArrayList;
import java.util.List;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.openscdp.kess.joingroup.CreateGroupMemberAction;
import org.openscdp.kess.joingroup.JoinGroupContent;
import org.openscdp.kess.joingroup.JoinGroupForm;
import org.openscdp.pkidb.dao.HolderDAO;
import org.openscdp.pkidb.dao.RoleDAO;
import org.openscdp.pkidb.dto.AssignedRoleDTO;
import org.openscdp.pkidb.dto.HolderDTO;
import org.openscdp.pkidb.dto.ServiceRequestDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.action.ServiceRequestAction;
import org.openscdp.pkidm.action.ServiceRequestSaveAction;
import org.openscdp.pkidm.holder.escrow.GroupSigner;
import org.openscdp.pkidm.servicerequest.ActionList;
import org.openscdp.pkidm.servicerequest.ServiceRequest;
import org.openscdp.pkidm.servicerequest.ServiceRequestCreationValidator;
import org.openscdp.pkidm.servicerequest.ServiceRequestForm;
import org.openscdp.pkidm.servicerequest.ServiceRequestWithFormBase;
import org.openscdp.pkidm.subject.TrustCenter;

public class JoinGroupServiceRequest
extends ServiceRequestWithFormBase
implements ServiceRequestCreationValidator,
ServiceRequestForm,
ActionList {
    public static final String PROCESS = "JoinGroup";
    private JoinGroupContent content;
    private JoinGroupForm form;
    private GroupSigner groupSigner;

    public JoinGroupServiceRequest(ServiceRequestDTO dto) {
        super(dto);
    }

    protected List<ServiceRequestAction> getActions() {
        ArrayList<ServiceRequestAction> list = new ArrayList<ServiceRequestAction>();
        if (this.getLifeCycle() <= 2) {
            list.add((ServiceRequestAction)new ServiceRequestSaveAction((ServiceRequest)this));
        }
        if (this.getLifeCycle() == 2 && this.getContent().getGroupSignerHolderId() > 0L && this.getContent().getTokenId() > 0L) {
            CreateGroupMemberAction createHolderAction = new CreateGroupMemberAction(this);
            createHolderAction.checkHolder();
            list.add((ServiceRequestAction)createHolderAction);
        }
        return list;
    }

    public JoinGroupForm getForm() {
        if (this.form == null) {
            this.form = new JoinGroupForm(this);
        }
        return this.form;
    }

    public GroupSigner getGroupSigner() {
        if (this.groupSigner == null) {
            try (Handle handle = PKIDMContext.getJDBI().open();){
                HolderDAO dao = (HolderDAO)handle.attach(HolderDAO.class);
                HolderDTO hdto = dao.getHolder(this.getContent().getGroupSignerHolderId());
                this.groupSigner = new GroupSigner(hdto);
            }
        }
        return this.groupSigner;
    }

    public TrustCenter getTrustCenter() {
        if (this.getGroupSigner() != null) {
            return this.getGroupSigner().getTrustCenter();
        }
        return null;
    }

    public boolean validateCreation() {
        this.dto.setTitle("Join Group");
        this.dto.setState("Created");
        this.dto.setOriginatorId(this.userId);
        return true;
    }

    public void commitForm() {
        if (this.form.saveForm()) {
            if (this.getLifeCycle() == 1) {
                this.setLifeCycle(2);
                this.setRoleId(this.getTrustCenter().getRaRoleId());
            }
            this.setStatusInfo("Data saved");
            this.commit(this.userId, null);
        }
    }

    public JoinGroupContent getContent() {
        if (this.content == null) {
            this.content = (JoinGroupContent)this.getContentView(JoinGroupContent.class);
        }
        return this.content;
    }

    public boolean hasRole(Long roleId) {
        AssignedRoleDTO roleAssignment;
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            RoleDAO dao = (RoleDAO)handle.attach(RoleDAO.class);
            roleAssignment = dao.getAssignedRole(this.userId.longValue(), roleId.longValue());
        }
        return roleAssignment != null;
    }
}

