/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.kess.joingroup;

import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.openscdp.kess.issuekdm.IssueKeyDomainMembershipServiceRequest;
import org.openscdp.kess.joingroup.JoinGroupContent;
import org.openscdp.kess.joingroup.JoinGroupServiceRequest;
import org.openscdp.pkidb.dao.HolderDAO;
import org.openscdp.pkidb.dto.HolderDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.action.ServiceRequestActionBase;
import org.openscdp.pkidm.action.ServiceRequestActionStates;
import org.openscdp.pkidm.json.JSONActionResult;
import org.openscdp.pkidm.servicerequest.ServiceRequest;
import org.openscdp.pkidm.servicerequest.ServiceRequestStateContent;
import org.openscdp.pkidm.servicerequest.ServiceRequestStateError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateGroupMemberAction
extends ServiceRequestActionBase {
    public static final String ACTION = "action.submit";
    public static final String ACTION_UPDATE = "action.update";
    private final Logger logger = LoggerFactory.getLogger(CreateGroupMemberAction.class);
    private JoinGroupServiceRequest sr;
    private JoinGroupContent content;
    protected HolderDTO dto;

    public CreateGroupMemberAction(JoinGroupServiceRequest serviceRequest) {
        super(ACTION, (ServiceRequest)serviceRequest);
        this.sr = serviceRequest;
        this.content = serviceRequest.getContent();
    }

    protected HolderDTO createOrUpdateHolder() {
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            HolderDAO dao = (HolderDAO)handle.attach(HolderDAO.class);
            HolderDTO template = this.getTemplate();
            Long holderId = dao.getHolderId(template.getCertificateType(), template.getParentId(), template.getName());
            if (holderId == null) {
                this.dto = dao.create(template);
            } else {
                dao.updateSubjectId(template.getSubjectId(), holderId);
                this.dto = dao.getHolder(holderId);
            }
            this.content.setHolderId(this.dto.getId());
            HolderDTO holderDTO = this.dto;
            return holderDTO;
        }
    }

    protected HolderDTO getTemplate() {
        HolderDTO holder = new HolderDTO();
        holder.setParentId(this.content.groupSignerHolderId);
        holder.setSubjectId(this.sr.getRecipientId());
        holder.setCertificateType(1);
        holder.setType("GroupMember");
        holder.setName(this.sr.getForm().getTokenPath());
        return holder;
    }

    public void checkHolder() {
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            HolderDAO dao = (HolderDAO)handle.attach(HolderDAO.class);
            HolderDTO template = this.getTemplate();
            Long id = dao.getHolderId(template.getCertificateType(), template.getParentId(), template.getName());
            if (id != null) {
                this.content.setHolderId(id);
                this.serviceRequest.setActionInfo("Token is already part of the group. Association with subject will change if token was re-assigned");
                this.key = ACTION_UPDATE;
            }
        }
    }

    protected ServiceRequestStateContent postProcess() throws Exception {
        this.serviceRequest.updateDetails(this.dto.getName());
        this.serviceRequest.setStatusInfo("Group joined");
        this.serviceRequest.setLifeCycle(11);
        this.serviceRequest.setRoleId(null);
        return null;
    }

    public JSONActionResult execute() {
        try {
            this.createOrUpdateHolder();
            IssueKeyDomainMembershipServiceRequest.create(this.sr, this.dto);
            ServiceRequestStateContent content = this.postProcess();
            this.serviceRequest.commit(content);
        }
        catch (Exception e) {
            this.logger.error("Joining group failed", (Throwable)e);
            this.serviceRequest.setStatusInfo("Joining group failed");
            this.serviceRequest.commit((ServiceRequestStateContent)new ServiceRequestStateError(e.getMessage()));
            return new JSONActionResult(ServiceRequestActionStates.FAILED, e.getMessage());
        }
        return new JSONActionResult(ServiceRequestActionStates.COMPLETED, "Group joined");
    }
}

