/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkicard;

import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.openscdp.pkidb.dao.TokenDAO;
import org.openscdp.pkidb.dto.TokenDTO;
import org.openscdp.pkidm.PKIDMContext;

public interface BackendToken {
    public String getTokenPath();

    default public String getBackendConnectedTo() {
        String path = this.getTokenPath();
        if (path == null) {
            return null;
        }
        return this.getBackendConnectedTo(path);
    }

    default public String getBackendConnectedTo(String tokenPath) {
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            TokenDAO dao = (TokenDAO)handle.attach(TokenDAO.class);
            TokenDTO dto = dao.getToken(tokenPath);
            if (dto.getOnline() == 0L) {
                String string = null;
                return string;
            }
            String string = dto.getLastSeenAt();
            return string;
        }
    }
}

