/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.cvc;

import de.cardcontact.opencard.eac.CardVerifiableCertificate;
import java.security.GeneralSecurityException;
import java.util.List;
import org.jdbi.v3.core.Handle;
import org.openscdp.pkidb.dao.CertificateDAO;
import org.openscdp.pkidb.dao.HolderDAO;
import org.openscdp.pkidb.dto.CertificateDTO;
import org.openscdp.pkidb.dto.HolderDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.holder.CVCertificateHolder;

public class CVCTools {
    public static void validateChain(List<CardVerifiableCertificate> chain) throws GeneralSecurityException {
        CardVerifiableCertificate parent = chain.get(chain.size() - 1);
        for (int i = chain.size() - 1; i >= 0; --i) {
            CardVerifiableCertificate cvc = chain.get(i);
            cvc.verify(parent);
            parent = cvc;
        }
    }

    private static CertificateDTO findCertificateDTO(Long holderId, CardVerifiableCertificate cvc) {
        try (Handle handle = PKIDMContext.getJDBI().open();){
            CertificateDAO certDAO = (CertificateDAO)handle.attach(CertificateDAO.class);
            List certs = certDAO.getCertificateBySerial(holderId, cvc.getCertificateHolderReference().toString());
            if (certs.size() > 1) {
                throw new RuntimeException("Certificate chain is not distinct for holder " + holderId);
            }
            if (certs.isEmpty()) {
                CertificateDTO certificateDTO = null;
                return certificateDTO;
            }
            CertificateDTO certificateDTO = (CertificateDTO)certs.get(0);
            return certificateDTO;
        }
    }

    public static CertificateDTO importCertificate(CardVerifiableCertificate cvc, Long parentId, String holderType) {
        try (Handle handle = PKIDMContext.getJDBI().open();){
            HolderDTO holderDTO;
            HolderDAO holderDAO = (HolderDAO)handle.attach(HolderDAO.class);
            String name = cvc.getCertificateHolderReference().getHolder();
            Long holderId = parentId == null ? holderDAO.getRootHolderId(1, name) : holderDAO.getHolderId(1, parentId, name);
            boolean makeCurrent = false;
            if (holderId == null) {
                holderDTO = new HolderDTO();
                if (parentId != null) {
                    holderDTO.setParentId(parentId);
                }
                holderDTO.setCertificateType(1);
                if (holderType != null) {
                    holderDTO.setType(holderType);
                }
                holderDTO.setName(name);
                holderDAO.create(holderDTO);
                makeCurrent = true;
            } else {
                CertificateDTO certDTO = CVCTools.findCertificateDTO(holderId, cvc);
                if (certDTO != null) {
                    CertificateDTO certificateDTO = certDTO;
                    return certificateDTO;
                }
                holderDTO = holderDAO.getHolder(holderId);
            }
            CVCertificateHolder holder = new CVCertificateHolder(holderDTO);
            Long certId = holder.storeCertificate(cvc, makeCurrent, null);
            CertificateDAO certDAO = (CertificateDAO)handle.attach(CertificateDAO.class);
            CertificateDTO certificateDTO = certDAO.getCertificate(certId);
            return certificateDTO;
        }
    }
}

