/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Objects;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.config.JdbiCache;
import org.jdbi.v3.core.config.JdbiCaches;
import org.jdbi.v3.core.statement.ArgumentBinder;
import org.jdbi.v3.core.statement.StatementContext;

class DescribedArgument
implements Argument {
    private static final JdbiCache<Class<?>, Boolean> ARG_CLASS_HAS_TOSTRING = JdbiCaches.declare(type -> {
        try {
            return type.getMethod("toString", new Class[0]).getDeclaringClass() != Object.class;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            return false;
        }
    });
    private final Argument arg;
    private final String description;

    DescribedArgument(Argument arg, Object value) {
        this.arg = arg;
        this.description = Objects.toString(ArgumentBinder.unwrap(value));
    }

    @Override
    public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
        this.arg.apply(position, statement, ctx);
    }

    public String toString() {
        return this.description;
    }

    public static Argument wrap(StatementContext ctx, Argument arg, Object value) {
        if (Boolean.TRUE.equals(ARG_CLASS_HAS_TOSTRING.get(arg.getClass(), ctx))) {
            return arg;
        }
        return new DescribedArgument(arg, value);
    }
}

