/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidb.dto;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Objects;

public class CertificateDTO {
    public static final int GOOD = 0;
    public static final int UNKNOWN = 1;
    public static final int REVOKED = 100;
    public static final int KEYCOMPROMISE = 101;
    public static final int CACOMPROMISE = 102;
    public static final int AFFILIATIONCHANGED = 103;
    public static final int SUPERSEDED = 104;
    public static final int CESSATIONOFOPERATION = 105;
    public static final int CERTIFICATEHOLD = 106;
    public static final int REMOVEFROMCRL = 108;
    public static final int PRIVILEGEWITHDRAWN = 109;
    public static final int AACOMPROMISE = 110;
    public static final int UP = 0;
    public static final int SHORT = 1;
    public static final int DOWN = 2;
    private Long id;
    private Long holderId;
    private Long serviceRequestId;
    private Long expiry;
    private int status;
    private LocalDateTime revocationDate;
    private LocalDateTime invalidityDate;
    private String serial;
    private int linkDir;
    private byte[] keyId;
    private byte[] bytes;

    public CertificateDTO() {
    }

    public CertificateDTO(Long id, Long holderId, Long serviceRequestId, Long expiry, int status, LocalDateTime revocationDate, LocalDateTime invalidityDate, String serial, int linkDir, byte[] keyId, byte[] bytes) {
        this.id = id;
        this.holderId = holderId;
        this.serviceRequestId = serviceRequestId;
        this.expiry = expiry;
        this.status = status;
        this.revocationDate = revocationDate;
        this.invalidityDate = invalidityDate;
        this.serial = serial;
        this.linkDir = linkDir;
        this.keyId = keyId;
        this.bytes = bytes;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getHolderId() {
        return this.holderId;
    }

    public void setHolderId(Long holderId) {
        this.holderId = holderId;
    }

    public Long getServiceRequestId() {
        return this.serviceRequestId;
    }

    public void setServiceRequestId(Long serviceRequestId) {
        this.serviceRequestId = serviceRequestId;
    }

    public Long getExpiry() {
        return this.expiry;
    }

    public void setExpiry(Long expiry) {
        this.expiry = expiry;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public LocalDateTime getRevocationDate() {
        return this.revocationDate;
    }

    public void setRevocationDate(LocalDateTime revocationDate) {
        this.revocationDate = revocationDate;
    }

    public LocalDateTime getInvalidityDate() {
        return this.invalidityDate;
    }

    public void setInvalidityDate(LocalDateTime invalidityDate) {
        this.invalidityDate = invalidityDate;
    }

    public String getSerial() {
        return this.serial;
    }

    public void setSerial(String serial) {
        this.serial = serial;
    }

    public int getLinkDir() {
        return this.linkDir;
    }

    public void setLinkDir(int linkDir) {
        this.linkDir = linkDir;
    }

    public byte[] getKeyId() {
        return this.keyId;
    }

    public void setKeyId(byte[] keyId) {
        this.keyId = keyId;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public String toString() {
        return "Certificate [id=" + this.id + ", holderId=" + this.holderId + ", serviceRequestId=" + this.serviceRequestId + ", expiry=" + this.expiry + ", status=" + this.status + ", revocationDate=" + this.revocationDate + ", invalidityDate=" + this.invalidityDate + ", serial=" + this.serial + ", linkDir=" + this.linkDir + ", keyId=" + Arrays.toString(this.keyId) + ", bytes=" + Arrays.toString(this.bytes) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.bytes);
        result = 31 * result + Arrays.hashCode(this.keyId);
        result = 31 * result + Objects.hash(this.expiry, this.holderId, this.id, this.invalidityDate, this.linkDir, this.revocationDate, this.serial, this.serviceRequestId, this.status);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CertificateDTO other = (CertificateDTO)obj;
        return Arrays.equals(this.bytes, other.bytes) && Objects.equals(this.expiry, other.expiry) && Objects.equals(this.holderId, other.holderId) && Objects.equals(this.id, other.id) && Objects.equals(this.invalidityDate, other.invalidityDate) && Arrays.equals(this.keyId, other.keyId) && this.linkDir == other.linkDir && Objects.equals(this.revocationDate, other.revocationDate) && Objects.equals(this.serial, other.serial) && Objects.equals(this.serviceRequestId, other.serviceRequestId) && this.status == other.status;
    }
}

