/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.pkcs15;

import de.cardcontact.tlv.OctetString;
import de.cardcontact.tlv.PrimitiveTLV;
import de.cardcontact.tlv.Sequence;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import de.cardcontact.tlv.Tag;
import de.cardcontact.tlv.UTF8String;

public class CommonObjectAttributes
extends Sequence {
    static final String NAME = "CommonObjectAttributes";
    private int labelIdx = -1;
    private int flagsIdx = -1;
    private int authIdIdx = -1;

    public CommonObjectAttributes(TLV tlv) throws TLVEncodingException {
        super(tlv);
        this.setName(NAME);
        int i = 0;
        TLV t = (TLV)this.childs.get(i);
        if (t.getTag().equals(Tag.TAG_UTF8String)) {
            this.labelIdx = i++;
            if (i >= this.childs.size()) {
                return;
            }
            t = (TLV)this.childs.get(i);
        }
        if (t.getTag().equals(Tag.TAG_BIT_STRING)) {
            this.flagsIdx = i++;
            if (i >= this.childs.size()) {
                return;
            }
            t = (TLV)this.childs.get(i);
        }
        if (t.getTag().equals(Tag.TAG_OCTET_STRING)) {
            this.authIdIdx = i++;
        }
    }

    public CommonObjectAttributes(String label, boolean privateObj, boolean modifiableObj, byte[] authId) {
        this.setName(NAME);
        if (label != null) {
            this.labelIdx = this.childs.size();
            this.childs.add(new UTF8String(label));
        }
        byte[] flags = new byte[]{6, (byte)((privateObj ? 128 : 0) + (modifiableObj ? 64 : 0))};
        this.flagsIdx = this.childs.size();
        this.childs.add(new PrimitiveTLV(Tag.TAG_BIT_STRING, flags));
        if (authId != null) {
            this.authIdIdx = this.childs.size();
            this.childs.add(new OctetString(authId));
        }
    }

    public String getLabel() {
        if (this.labelIdx == -1) {
            return null;
        }
        return ((UTF8String)this.childs.get(this.labelIdx)).toString();
    }

    public boolean isPrivate() {
        if (this.flagsIdx == -1) {
            return false;
        }
        byte[] flags = ((TLV)this.childs.get(this.flagsIdx)).getValue();
        return (flags[1] & 0x80) == 128;
    }

    public boolean isModifiable() {
        if (this.flagsIdx == -1) {
            return false;
        }
        byte[] flags = ((TLV)this.childs.get(this.flagsIdx)).getValue();
        return (flags[1] & 0x40) == 64;
    }

    public byte[] getAuthId() {
        if (this.authIdIdx == -1) {
            return null;
        }
        return ((TLV)this.childs.get(this.authIdIdx)).getValue();
    }
}

