/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.kess.issuekdm;

import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import org.openscdp.kess.ImportDeviceCertificate;
import org.openscdp.pkicard.ServiceRequestSmartCardHSMAction;
import org.openscdp.pkidm.action.ServiceRequestActionException;
import org.openscdp.pkidm.cvc.importer.SCHSMTokenCertificateImporter;
import org.openscdp.pkidm.servicerequest.ServiceRequest;
import org.openscdp.pkidm.servicerequest.ServiceRequestStateContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportDeviceCertificateAction
extends ServiceRequestSmartCardHSMAction {
    public static final String ACTION = "action.kess.kdm.certificate";
    private final Logger logger = LoggerFactory.getLogger(ImportDeviceCertificateAction.class);
    private ImportDeviceCertificate sr;
    private String tokenPath;

    public ImportDeviceCertificateAction(ImportDeviceCertificate serviceRequest) {
        super(ACTION, (ServiceRequest)serviceRequest);
        this.sr = serviceRequest;
    }

    public boolean preFlightCheck() {
        this.tokenPath = this.sr.getTokenPath();
        if (this.tokenPath == null) {
            return false;
        }
        return !this.sr.hasDeviceCertificate();
    }

    protected ServiceRequestStateContent postProcess() throws ServiceRequestActionException {
        this.sr.setStatusInfo("Device Certificate imported");
        this.sr.setLifeCycle(2);
        return null;
    }

    public void execute(SmartCardHSMProvider provider) {
        try {
            if (!this.preFlightCheck()) {
                throw new ServiceRequestActionException("Precondition for service request not fulfilled");
            }
            String id = provider.getSmartCardHSMCardService().getId();
            if (!id.equals(this.tokenPath)) {
                throw new ServiceRequestActionException("Wrong Token presented");
            }
            SCHSMTokenCertificateImporter importer = new SCHSMTokenCertificateImporter("KESS");
            importer.importDeviceChain(provider.getSmartCardHSMCardService());
            this.postProcess();
        }
        catch (Exception e) {
            this.logger.error("Import of the device certificate failed", (Throwable)e);
            throw new ServiceRequestActionException(e.getMessage(), (Throwable)e);
        }
    }

    public String getKey() {
        return ACTION;
    }

    public ServiceRequest getServiceRequest() {
        return this.sr;
    }
}

