/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkicard.escrow;

import de.cardcontact.opencard.eac.CardVerifiableCertificate;
import de.cardcontact.opencard.service.eac20.EAC20;
import de.cardcontact.opencard.service.smartcardhsm.KeyDomain;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMECPrivateKeySpec;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMKey;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMKeySpec;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMPrivateKey;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMParameterSpec;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import de.cardcontact.tlv.TLVEncodingException;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import opencard.core.OpenCardException;
import opencard.core.service.CardServiceException;
import opencard.core.terminal.CardTerminalException;
import org.openscdp.pkicard.escrow.SmartCardHSMCertificateChainTLV;
import org.openscdp.pkidm.action.ServiceRequestActionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XKEKKeyDomain {
    private final Logger logger = LoggerFactory.getLogger(XKEKKeyDomain.class);
    private SmartCardHSMProvider provider;
    private byte[] kdUID;
    private SmartCardHSMPrivateKey ephemeralKey;
    private SmartCardHSMCertificateChainTLV ephemeralChain;

    public XKEKKeyDomain(SmartCardHSMProvider provider, byte[] kdUID) {
        this.provider = provider;
        this.kdUID = kdUID;
    }

    public SmartCardHSMPrivateKey generateExportKey(String escrowName) {
        String label = escrowName + ".export";
        return this.generateEphemeralKey(label);
    }

    public SmartCardHSMPrivateKey generateExchangeKey(String escrowName) {
        String label = escrowName + ".exchange";
        return this.generateEphemeralKey(label);
    }

    public SmartCardHSMPrivateKey generateEphemeralKey(String label) {
        KeyStore ks;
        this.logger.debug("Generate ephemeral key " + label);
        try {
            ks = KeyStore.getInstance("SmartCardHSMKeyStore", (Provider)this.provider);
            ks.load(null);
            if (ks.containsAlias(label)) {
                ks.deleteEntry(label);
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            this.logger.error("Removing old key failed", (Throwable)e);
            throw new ServiceRequestActionException("Removing old key failed", (Throwable)e);
        }
        SmartCardHSMECPrivateKeySpec ecSpec = new SmartCardHSMECPrivateKeySpec((AlgorithmParameterSpec)EAC20.getECParameterSpecforBrainpoolP256r1());
        ecSpec.setAlgorithmList(new byte[]{-124});
        KeyDomain kd = null;
        try {
            SmartCardHSMCardService service = this.provider.getSmartCardHSMCardService();
            for (KeyDomain keyDomain : service.getKeyDomains()) {
                if (!Arrays.equals(keyDomain.getKeyDomainUID(), this.kdUID)) continue;
                kd = keyDomain;
                break;
            }
        }
        catch (OpenCardException e) {
            this.logger.error("Key Domain enumeration failed", (Throwable)e);
            throw new ServiceRequestActionException("Key Domain enumeration failed", (Throwable)e);
        }
        if (kd == null) {
            throw new ServiceRequestActionException("Escrow key domain not found");
        }
        ecSpec.setKeyDomain(kd);
        SmartCardHSMParameterSpec hsmParam = new SmartCardHSMParameterSpec(label, (SmartCardHSMKeySpec)ecSpec);
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC//ECDSA-SHA-256", (Provider)this.provider);
            kpg.initialize((AlgorithmParameterSpec)hsmParam, null);
            KeyPair kp = kpg.generateKeyPair();
            this.ephemeralKey = (SmartCardHSMPrivateKey)kp.getPrivate();
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            this.logger.error("Generating export key failed", (Throwable)e);
            throw new ServiceRequestActionException("Generating export key failed", (Throwable)e);
        }
        try {
            CardVerifiableCertificate[] chain = this.provider.getSmartCardHSMCardService().getCertificateChain();
            this.ephemeralChain = new SmartCardHSMCertificateChainTLV(chain[1], chain[0], (CardVerifiableCertificate)ks.getCertificate(label));
        }
        catch (KeyStoreException | CertificateEncodingException | CardServiceException | CardTerminalException e) {
            this.logger.error("Public key not found for label " + label, e);
            throw new ServiceRequestActionException("Public key not found", e);
        }
        return this.ephemeralKey;
    }

    public void deleteEphemeralKey() {
        if (this.ephemeralKey == null) {
            throw new ServiceRequestActionException("No ephemeral key has been set or generated");
        }
        this.deleteKey((SmartCardHSMKey)this.ephemeralKey);
    }

    public void deleteKey(SmartCardHSMKey key) {
        if (key == null) {
            throw new ServiceRequestActionException("Missing key parameter");
        }
        String label = key.getLabel();
        this.logger.debug("Delete key " + label);
        try {
            KeyStore ks = KeyStore.getInstance("SmartCardHSMKeyStore", (Provider)this.provider);
            ks.load(null);
            if (ks.containsAlias(label)) {
                ks.deleteEntry(label);
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            this.logger.error("Deletion of key " + label + " failed", (Throwable)e);
            throw new ServiceRequestActionException("Deletion of key " + label + " failed", (Throwable)e);
        }
    }

    public SmartCardHSMPrivateKey getEphemeralKey() {
        return this.ephemeralKey;
    }

    public void setEphemeralKey(SmartCardHSMPrivateKey ephemeralKey) {
        this.ephemeralKey = ephemeralKey;
    }

    public SmartCardHSMCertificateChainTLV getEphemeralChain() {
        return this.ephemeralChain;
    }

    public void deriveXKEKWith(SmartCardHSMCertificateChainTLV peerChain) {
        try {
            this.deriveXKEKWith(peerChain.getCertificate(), peerChain.getDeviceCertificate(), peerChain.getDICACertificate());
        }
        catch (TLVEncodingException | CertificateException e) {
            throw new ServiceRequestActionException("Invalid peer chain");
        }
    }

    public void deriveXKEKWith(List<CardVerifiableCertificate> peerChain) {
        this.deriveXKEKWith(peerChain.get(0), peerChain.get(1), peerChain.get(2));
    }

    public void deriveXKEKWith(CardVerifiableCertificate peerCert, CardVerifiableCertificate peerDeviceCert, CardVerifiableCertificate peerDICACert) {
        if (this.ephemeralKey == null) {
            throw new ServiceRequestActionException("No ephemeral key has been set or generated");
        }
        CardVerifiableCertificate[] chain = new CardVerifiableCertificate[]{peerCert, peerDeviceCert, peerDICACert};
        try {
            SmartCardHSMCardService service = this.provider.getSmartCardHSMCardService();
            service.verifyCertificateChain(chain);
            service.deriveXKEK(this.ephemeralKey.getKeyRef(), peerCert);
        }
        catch (OpenCardException e) {
            this.logger.error("XKEK derivation failed", (Throwable)e);
            throw new ServiceRequestActionException("Could not derive XKEK with peer " + String.valueOf(peerCert) + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public byte[] wrapKey(Key key) {
        try {
            Cipher cipher = Cipher.getInstance("WRAP", (Provider)this.provider);
            Key nullKey = null;
            cipher.init(3, nullKey);
            byte[] encoded = cipher.wrap(key);
            return encoded;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | IllegalBlockSizeException | NoSuchPaddingException e) {
            this.logger.error("Wrapping key failed", (Throwable)e);
            throw new ServiceRequestActionException("Wrapping key failed", (Throwable)e);
        }
    }

    public SmartCardHSMKey unwrapKey(byte[] wrappedKey) {
        try {
            Cipher cipher = Cipher.getInstance("WRAP", (Provider)this.provider);
            Key nullKey = null;
            cipher.init(4, nullKey);
            String nullAlgorithm = null;
            SmartCardHSMKey key = (SmartCardHSMKey)cipher.unwrap(wrappedKey, nullAlgorithm, 2);
            return key;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            this.logger.error("Unwrapping key failed", (Throwable)e);
            throw new ServiceRequestActionException("Unwrapping key failed", (Throwable)e);
        }
    }

    public SmartCardHSMKey getKey(String alias) {
        try {
            KeyStore ks = KeyStore.getInstance("SmartCardHSMKeyStore", (Provider)this.provider);
            ks.load(null);
            SmartCardHSMKey key = (SmartCardHSMKey)ks.getKey(alias, null);
            if (key == null) {
                return null;
            }
            if (Arrays.equals(this.kdUID, key.getKeyDomain().getKeyDomainUID())) {
                return key;
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            this.logger.error("Get key failed", (Throwable)e);
            throw new ServiceRequestActionException("Get key failed", (Throwable)e);
        }
        return null;
    }

    public SmartCardHSMKey getKey(byte[] keyId) {
        SmartCardHSMCardService service = this.provider.getSmartCardHSMCardService();
        try {
            String alias = service.getAliasForKeyId(keyId);
            return this.getKey(alias);
        }
        catch (OpenCardException e) {
            this.logger.error("Get key failed", (Throwable)e);
            throw new ServiceRequestActionException("Get key failed", (Throwable)e);
        }
    }
}

