/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.kess.sendtoescrow;

import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import java.security.cert.CertPathBuilderException;
import java.util.ArrayList;
import opencard.core.OpenCardException;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.form.KeyDomainSelectField;
import org.openscdp.pkidm.form.OptionGroupValue;
import org.openscdp.pkidm.form.SelectFieldValue;
import org.openscdp.pkidm.holder.CVCertificateHolder;
import org.openscdp.pkihsmsrv.HSMService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EscrowDomainSelectField
extends KeyDomainSelectField {
    private final Logger logger = LoggerFactory.getLogger(EscrowDomainSelectField.class);

    public EscrowDomainSelectField(String id, String label, boolean editable, CVCertificateHolder keyEscrowHolder) {
        super(id, label, editable);
        HSMService hsmService = PKIDMContext.getHSMService();
        byte[] keyDomain = keyEscrowHolder.getSigner().getKeyDomain();
        ArrayList providers = hsmService.getProvider(keyDomain);
        for (SmartCardHSMProvider provider : providers) {
            SmartCardHSMCardService service = provider.getSmartCardHSMCardService();
            try {
                OptionGroupValue opt = new OptionGroupValue();
                opt.label = service.getId();
                opt.value.add(this.createKeyDomainSelectValue(service.getDefaultKeyDomainUID(), keyDomain));
                this.add((SelectFieldValue)opt);
            }
            catch (CertPathBuilderException | OpenCardException e) {
                this.logger.warn("Enumeration of key domains failed for token " + id, e);
            }
        }
    }
}

